package org.seasar.dao;

import java.sql.DatabaseMetaData;

import org.seasar.extension.jdbc.ColumnNotFoundRuntimeException;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.framework.beans.PropertyNotFoundRuntimeException;

/**
 * @author higa
 *
 */
public interface BeanMetaData {
	
	public String TABLE_KEY = "TABLE";
	public String COLUMN_KEY_SUFFIX = "_COLUMN";
	public String RELNO_KEY_SUFFIX = "_RELNO";
	public String RELKEYS_KEY_SUFFIX = "_RELKEYS";
	public String VERSION_NO_PROPERTY_NAME = "versionNo";

	public Class getBeanClass();

	public String getTableName();
	
	public int getPropertyTypeSize();
	
	public PropertyType getPropertyType(int index);
	
	public PropertyType getPropertyType(String propertyName)
		throws PropertyNotFoundRuntimeException;
	
	public PropertyType getVersionNoPropertyType()
		throws PropertyNotFoundRuntimeException;
	
	public boolean hasPropertyType(String propertyName);
	
	public boolean hasVersionNoPropertyType();
	
	public String convertFullColumnName(String alias);
	
	public PropertyType getPropertyTypeByColumnName(String columnName)
		throws ColumnNotFoundRuntimeException;
	
	public boolean hasPropertyTypeByColumnName(String columnName);
	
	public int getRelationPropertyTypeSize();
	
	public RelationPropertyType getRelationPropertyType(int index);
	
	public RelationPropertyType getRelationPropertyType(String propertyName)
		throws PropertyNotFoundRuntimeException;
	
	public boolean isPersistent();
	
	public boolean setupDatabaseMetaData(DatabaseMetaData dbMetaData);
	
	public int getPrimaryKeySize();
	
	public String getPrimaryKey(int index);
	
	public String getAutoInsertSql();
	
	public String getAutoUpdateSql();
	
	public String getAutoDeleteSql();
	
	public String getAutoSelectList();
	
	public Object[] getAutoInsertBindVariables(Object bean);
	
	public Object[] getAutoUpdateBindVariables(Object bean);
	
	public Object[] getAutoDeleteBindVariables(Object bean);
}