package org.seasar.dao.impl;

import javax.sql.DataSource;

import org.seasar.dao.BeanMetaData;
import org.seasar.dao.CommandContext;
import org.seasar.dao.Dialect;
import org.seasar.dao.dialect.DialectManager;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.SelectHandler;

/**
 * @author higa
 *
 */
public class SelectDynamicAutoCommand extends SelectDynamicCommand {

	/**
	 * @param beanMetaData
	 * @param resultSetHandler
	 */
	public SelectDynamicAutoCommand(BeanMetaData beanMetaData,
			ResultSetHandler resultSetHandler) {
		super(beanMetaData, resultSetHandler);
	}

	/**
	 * @see org.seasar.dao.impl.SelectDynamicCommand#createSelectHandler(javax.sql.DataSource)
	 */
	protected SelectHandler createSelectHandler(DataSource ds) {
		return new SelectDynamicAutoHandler(ds,
				getResultSetHandler(), getBeanMetaData(), this);
	}
	
	/**
	 * @see org.seasar.dao.impl.AbstractDynamicCommand#apply(java.lang.Object[])
	 */
	protected CommandContext apply(Object[] args) {
		if (getSql() == null) {
			synchronized (this) {
				if (getSql() == null) {
					setupSql();
				}
			}
		}
		return super.apply(args);
	}
	
	protected void setupSql() {
		Dialect dialect = DialectManager.getDialect();
		String sql = dialect.getAutoSelectSql(getBeanMetaData());
		if (getArgNames().length == 0) {
			setSql(sql);
		} else {
			StringBuffer buf = new StringBuffer(sql);
			boolean began = false;
			if (!(sql.lastIndexOf("WHERE") > 0)) {
				buf.append("/*BEGIN*/ WHERE ");
				began = true;
			}
			for (int i = 0; i < getArgNames().length; ++i) {
				String columnName = getBeanMetaData().convertFullColumnName(getArgNames()[i]);
				buf.append("/*IF ");
				buf.append(getArgNames()[i]);
				buf.append(" != null*/");
				buf.append(" AND ");
				buf.append(columnName);
				buf.append(" = /*");
				buf.append(getArgNames()[i]);
				buf.append("*/null");
				buf.append("/*END*/");
			}
			if (began) {
				buf.append("/*END*/");
			}
			setSql(buf.toString());
		}
	}
}
