package org.seasar.dao.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.seasar.dao.BeanMetaData;
import org.seasar.dao.CommandContext;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;

/**
 * @author higa
 *
 */
public class SelectDynamicHandler extends BasicSelectHandler {
	
	private BeanMetaData beanMetaData_;
	private SelectDynamicCommand selectDynamicCommand_;
	
	public SelectDynamicHandler(DataSource dataSource,
			ResultSetHandler resultSetHandler, BeanMetaData beanMetaData,
			SelectDynamicCommand selectDynamicCommand) {

		super(dataSource, null, resultSetHandler);
		beanMetaData_ = beanMetaData;
		selectDynamicCommand_ = selectDynamicCommand;
	}

	protected Object[] setup(Connection con, Object[] args)
			throws SQLException {

		setupMetaData(con.getMetaData());
		CommandContext ctx = selectDynamicCommand_.apply(args);
		setSql(ctx.getSql());
		return ctx.getBindVariables();
	}
	
	protected void setupMetaData(DatabaseMetaData dbMetaData)
			throws SQLException{

		beanMetaData_.setupDatabaseMetaData(dbMetaData);
	}
}
