/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.impl;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.exception.EmptyRuntimeException;

public final class PointcutImpl
implements Pointcut {
    private String[] methodNames_;
    private Pattern[] patterns_;
    static /* synthetic */ Class class$0;

    public PointcutImpl(Class targetClass) throws EmptyRuntimeException {
        if (targetClass == null) {
            throw new EmptyRuntimeException("targetClass");
        }
        this.setMethodNames(PointcutImpl.getMethodNames(targetClass));
    }

    public PointcutImpl(String[] methodNames) throws EmptyRuntimeException {
        if (methodNames == null || methodNames.length == 0) {
            throw new EmptyRuntimeException("methodNames");
        }
        this.setMethodNames(methodNames);
    }

    public boolean isApplied(String methodName) {
        int i = 0;
        while (i < this.patterns_.length) {
            if (this.patterns_[i].matcher(methodName).matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getMethodNames() {
        return this.methodNames_;
    }

    private void setMethodNames(String[] methodNames) {
        this.methodNames_ = methodNames;
        this.patterns_ = new Pattern[methodNames.length];
        int i = 0;
        while (i < this.patterns_.length) {
            this.patterns_[i] = Pattern.compile(methodNames[i]);
            ++i;
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] getMethodNames(Class targetClass) {
        Class<?> clazz;
        HashSet methodNameSet = new HashSet();
        if (targetClass.isInterface()) {
            PointcutImpl.addInterfaceMethodNames(methodNameSet, targetClass);
        }
        Class clazz2 = targetClass;
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                Class<?>[] interfaces = clazz2.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    PointcutImpl.addInterfaceMethodNames(methodNameSet, interfaces[i]);
                    ++i;
                }
                clazz2 = clazz2.getSuperclass();
            }
            if ((clazz = class$0) != null) continue;
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz2 != clazz && clazz2 != null);
        return methodNameSet.toArray(new String[methodNameSet.size()]);
    }

    private static void addInterfaceMethodNames(Set methodNameSet, Class interfaceClass) {
        Method[] methods = interfaceClass.getDeclaredMethods();
        int j = 0;
        while (j < methods.length) {
            methodNameSet.add(methods[j].getName());
            ++j;
        }
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            PointcutImpl.addInterfaceMethodNames(methodNameSet, interfaces[i]);
            ++i;
        }
    }
}

