/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.util.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    private XmlUtils() {
    }

    public static String getElementText(Element elem) {
        StringBuffer buf = new StringBuffer();
        NodeList nodeList = elem.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nodeList.item(i);
            if (n.getNodeType() != 3) continue;
            buf.append(n.getNodeValue());
        }
        return buf.toString();
    }

    public static String getChildText(Element elem, String childTagName) {
        NodeList nodeList = elem.getElementsByTagName(childTagName);
        int len = nodeList.getLength();
        if (len == 0) {
            return null;
        }
        return XmlUtils.getElementText((Element)nodeList.item(len - 1));
    }

    public static List getChildTextList(Element elem, String childTagName) {
        NodeList nodeList = elem.getElementsByTagName(childTagName);
        int len = nodeList.getLength();
        if (len == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> list = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            list.add(XmlUtils.getElementText((Element)nodeList.item(i)));
        }
        return list;
    }
}

