/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.html.filters;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.HTMLElements;
import org.cyberneko.html.HTMLEntities;
import org.cyberneko.html.filters.DefaultFilter;
import org.cyberneko.html.filters.Identity;
import org.cyberneko.html.filters.Purifier;

public class Writer
extends DefaultFilter {
    public static final String NOTIFY_CHAR_REFS = "http://apache.org/xml/features/scanner/notify-char-refs";
    public static final String NOTIFY_HTML_BUILTIN_REFS = "http://cyberneko.org/html/features/scanner/notify-builtin-refs";
    protected static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    protected static final String FILTERS = "http://cyberneko.org/html/properties/filters";
    protected String fEncoding;
    protected PrintWriter fPrinter;
    protected boolean fSeenRootElement;
    protected boolean fSeenHttpEquiv;
    protected int fElementDepth;
    protected boolean fNormalize;
    protected boolean fPrintChars;
    static /* synthetic */ Class class$org$cyberneko$html$filters$Writer;

    public Writer() {
        try {
            this.fEncoding = "UTF-8";
            this.fPrinter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, this.fEncoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }

    public Writer(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(outputStream, string), string);
    }

    public Writer(java.io.Writer writer, String string) {
        this.fEncoding = string;
        this.fPrinter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = false;
        this.fSeenHttpEquiv = false;
        this.fElementDepth = 0;
        this.fNormalize = true;
        this.fPrintChars = true;
        super.startDocument(xMLLocator, string, namespaceContext, augmentations);
    }

    public void startDocument(XMLLocator xMLLocator, String string, Augmentations augmentations) throws XNIException {
        this.startDocument(xMLLocator, string, null, augmentations);
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElement && this.fElementDepth <= 0) {
            this.fPrinter.println();
        }
        this.fPrinter.print("<!--");
        this.printCharacters(xMLString, false);
        this.fPrinter.print("-->");
        if (!this.fSeenRootElement) {
            this.fPrinter.println();
        }
        this.fPrinter.flush();
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = true;
        ++this.fElementDepth;
        this.fNormalize = !HTMLElements.getElement(qName.rawname).isSpecial();
        this.printStartElement(qName, xMLAttributes);
        super.startElement(qName, xMLAttributes, augmentations);
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = true;
        this.printStartElement(qName, xMLAttributes);
        super.emptyElement(qName, xMLAttributes, augmentations);
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fPrintChars) {
            this.printCharacters(xMLString, this.fNormalize);
        }
        super.characters(xMLString, augmentations);
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        --this.fElementDepth;
        this.fNormalize = true;
        this.printEndElement(qName);
        super.endElement(qName, augmentations);
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        this.fPrintChars = false;
        if (string.startsWith("#")) {
            try {
                boolean bl = string.startsWith("#x");
                int n = bl ? 2 : 1;
                int n2 = bl ? 16 : 10;
                int n3 = Integer.parseInt(string.substring(n), n2);
                String string3 = HTMLEntities.get(n3);
                if (string3 != null) {
                    string = string3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.printEntity(string);
        super.startGeneralEntity(string, xMLResourceIdentifier, string2, augmentations);
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        this.fPrintChars = true;
        super.endGeneralEntity(string, augmentations);
    }

    protected void printAttributeValue(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                this.fPrinter.print("&quot;");
                continue;
            }
            this.fPrinter.print(c);
        }
        this.fPrinter.flush();
    }

    protected void printCharacters(XMLString xMLString, boolean bl) {
        if (bl) {
            for (int i = 0; i < xMLString.length; ++i) {
                char c = xMLString.ch[xMLString.offset + i];
                if (c != '\n') {
                    String string = HTMLEntities.get(c);
                    if (string != null) {
                        this.printEntity(string);
                        continue;
                    }
                    this.fPrinter.print(c);
                    continue;
                }
                this.fPrinter.println();
            }
        } else {
            for (int i = 0; i < xMLString.length; ++i) {
                char c = xMLString.ch[xMLString.offset + i];
                this.fPrinter.print(c);
            }
        }
        this.fPrinter.flush();
    }

    protected void printStartElement(QName qName, XMLAttributes xMLAttributes) {
        int n;
        int n2 = -1;
        String string = null;
        if (qName.rawname.toLowerCase().equals("meta")) {
            String string2 = null;
            n = xMLAttributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string3 = xMLAttributes.getQName(i).toLowerCase();
                if (string3.equals("http-equiv")) {
                    string2 = xMLAttributes.getValue(i);
                    continue;
                }
                if (!string3.equals("content")) continue;
                n2 = i;
            }
            if (string2 != null && string2.toLowerCase().equals("content-type")) {
                this.fSeenHttpEquiv = true;
                String string4 = null;
                if (n2 != -1) {
                    string = xMLAttributes.getValue(n2);
                    string4 = string.toLowerCase();
                }
                if (string4 != null) {
                    int n3 = string4.indexOf("charset=");
                    string4 = n3 != -1 ? string4.substring(0, n3 + 8) : string4 + ";charset=";
                    string4 = string4 + this.fEncoding;
                    xMLAttributes.setValue(n2, string4);
                }
            }
        }
        this.fPrinter.print('<');
        this.fPrinter.print(qName.rawname);
        int n4 = xMLAttributes != null ? xMLAttributes.getLength() : 0;
        for (n = 0; n < n4; ++n) {
            String string5 = xMLAttributes.getQName(n);
            String string6 = xMLAttributes.getValue(n);
            this.fPrinter.print(' ');
            this.fPrinter.print(string5);
            this.fPrinter.print("=\"");
            this.printAttributeValue(string6);
            this.fPrinter.print('\"');
        }
        this.fPrinter.print('>');
        this.fPrinter.flush();
        if (n2 != -1) {
            xMLAttributes.setValue(n2, string);
        }
    }

    protected void printEndElement(QName qName) {
        this.fPrinter.print("</");
        this.fPrinter.print(qName.rawname);
        this.fPrinter.print('>');
        this.fPrinter.flush();
    }

    protected void printEntity(String string) {
        this.fPrinter.print('&');
        this.fPrinter.print(string);
        this.fPrinter.print(';');
        this.fPrinter.flush();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            Writer.printUsage();
            System.exit(1);
        }
        HTMLConfiguration hTMLConfiguration = new HTMLConfiguration();
        hTMLConfiguration.setFeature(NOTIFY_CHAR_REFS, true);
        hTMLConfiguration.setFeature(NOTIFY_HTML_BUILTIN_REFS, true);
        String string = "Windows-1252";
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.equals("-e")) {
                string = stringArray[++i];
                continue;
            }
            if (string2.equals("-i")) {
                bl = true;
                continue;
            }
            if (string2.equals("-p")) {
                bl2 = true;
                continue;
            }
            if (string2.equals("-h")) {
                Writer.printUsage();
                System.exit(1);
            }
            Vector<DefaultFilter> vector = new Vector<DefaultFilter>(2);
            if (bl) {
                vector.addElement(new Identity());
            } else if (bl2) {
                vector.addElement(new Purifier());
            }
            vector.addElement(new Writer(System.out, string));
            Object[] objectArray = new XMLDocumentFilter[vector.size()];
            vector.copyInto(objectArray);
            hTMLConfiguration.setProperty(FILTERS, objectArray);
            hTMLConfiguration.parse(new XMLInputSource(null, string2, null));
        }
    }

    private static void printUsage() {
        System.err.println("usage: java " + (class$org$cyberneko$html$filters$Writer == null ? (class$org$cyberneko$html$filters$Writer = Writer.class$("org.cyberneko.html.filters.Writer")) : class$org$cyberneko$html$filters$Writer).getName() + " (options) file ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -e name  Specify IANA name of output encoding.");
        System.err.println("  -i       Perform identity transform.");
        System.err.println("  -p       Purify output to ensure XML well-formedness.");
        System.err.println("  -h       Display help screen.");
        System.err.println();
        System.err.println("notes:");
        System.err.println("  The -i and -p options are mutually exclusive.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

