/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbcp.impl;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.seasar.extension.dbcp.ConnectionPool;
import org.seasar.extension.dbcp.ConnectionWrapper;
import org.seasar.extension.dbcp.impl.ConnectionWrapperImpl;
import org.seasar.extension.timer.TimeoutManager;
import org.seasar.extension.timer.TimeoutTarget;
import org.seasar.extension.timer.TimeoutTask;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.SLinkedList;
import org.seasar.framework.util.TransactionManagerUtil;
import org.seasar.framework.util.TransactionUtil;

public final class ConnectionPoolImpl
implements ConnectionPool,
Synchronization {
    private static Logger logger_;
    private XADataSource xaDataSource_;
    private TransactionManager transactionManager_;
    private int timeout_ = 600;
    private int maxPoolSize_ = 10;
    private Set activePool_ = new HashSet();
    private Map txActivePool_ = new HashMap();
    private SLinkedList freePool_ = new SLinkedList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.extension.dbcp.impl.ConnectionPoolImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public XADataSource getXADataSource() {
        return this.xaDataSource_;
    }

    public void setXADataSource(XADataSource xaDataSource) {
        this.xaDataSource_ = xaDataSource;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager_;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager_ = transactionManager;
    }

    public int getTimeout() {
        return this.timeout_;
    }

    public void setTimeout(int timeout) {
        this.timeout_ = timeout;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize_;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize_ = maxPoolSize;
    }

    public int getActivePoolSize() {
        return this.activePool_.size();
    }

    public int getTxActivePoolSize() {
        return this.txActivePool_.size();
    }

    public int getFreePoolSize() {
        return this.freePool_.size();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized ConnectionWrapper checkOut() throws SQLException {
        tx = this.getTransaction();
        con = this.getConnectionTxActivePool(tx);
        if (con == null) ** GOTO lbl11
        con.init();
        return con;
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException var3_3) {
                // empty catch block
            }
lbl11:
            // 3 sources

            ** while (this.getActivePoolSize() + this.getTxActivePoolSize() >= this.getMaxPoolSize())
        }
lbl12:
        // 1 sources

        con = this.checkOutFreePool();
        if (con == null) {
            con = this.createConnection();
        } else {
            con.init();
        }
        if (tx != null) {
            TransactionUtil.enlistResource((Transaction)tx, (XAResource)con.getXAResource());
            TransactionUtil.registerSynchronization((Transaction)tx, (Synchronization)this);
            this.setConnectionTxActivePool(tx, con);
        } else {
            this.setConnectionActivePool(con);
        }
        return con;
    }

    private Transaction getTransaction() {
        return TransactionManagerUtil.getTransaction((TransactionManager)this.transactionManager_);
    }

    private ConnectionWrapper getConnectionTxActivePool(Transaction tx) {
        return (ConnectionWrapper)this.txActivePool_.get(tx);
    }

    private ConnectionWrapper checkOutFreePool() {
        if (this.freePool_.isEmpty()) {
            return null;
        }
        FreeItem item = (FreeItem)this.freePool_.removeLast();
        ConnectionWrapper con = item.getConnection();
        item.destroy();
        return con;
    }

    private ConnectionWrapper createConnection() throws SQLException {
        ConnectionWrapperImpl con = new ConnectionWrapperImpl(this.xaDataSource_.getXAConnection(), this);
        logger_.log("DSSR0006", null);
        return con;
    }

    private void setConnectionTxActivePool(Transaction tx, ConnectionWrapper connection) {
        this.txActivePool_.put(tx, connection);
    }

    private void setConnectionActivePool(ConnectionWrapper connection) {
        this.activePool_.add(connection);
    }

    public synchronized void release(ConnectionWrapper connection) {
        this.activePool_.remove(connection);
        Transaction tx = this.getTransaction();
        if (tx != null) {
            this.txActivePool_.remove(tx);
        }
        connection.closeReally();
        this.notify();
    }

    public synchronized void checkIn(ConnectionWrapper connection) {
        this.activePool_.remove(connection);
        Transaction tx = this.getTransaction();
        if (tx == null) {
            this.checkInFreePool(connection);
        }
        this.notify();
    }

    private void checkInFreePool(ConnectionWrapper connection) {
        this.freePool_.addLast((Object)new FreeItem(connection));
    }

    public void afterCompletion(int status) {
        switch (status) {
            case 3: 
            case 4: {
                this.checkInTx();
            }
        }
    }

    private void checkInTx() {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            return;
        }
        ConnectionWrapper con = this.checkOutTxPool(tx);
        if (con == null) {
            return;
        }
        this.checkInFreePool(con);
    }

    private ConnectionWrapper checkOutTxPool(Transaction tx) {
        return (ConnectionWrapper)this.txActivePool_.remove(tx);
    }

    public final void beforeCompletion() {
    }

    public final synchronized void close() {
        ConnectionWrapper con;
        SLinkedList.Entry e = this.freePool_.getFirstEntry();
        while (e != null) {
            FreeItem item = (FreeItem)e.getElement();
            item.getConnection().closeReally();
            e = e.getNext();
        }
        this.freePool_.clear();
        Iterator<Object> i = this.txActivePool_.values().iterator();
        while (i.hasNext()) {
            con = (ConnectionWrapper)i.next();
            con.closeReally();
        }
        this.txActivePool_.clear();
        i = this.activePool_.iterator();
        while (i.hasNext()) {
            con = (ConnectionWrapper)i.next();
            con.closeReally();
        }
        this.activePool_.clear();
    }

    private class FreeItem
    implements TimeoutTarget {
        private ConnectionWrapper connectionWrapper_;
        private TimeoutTask timeoutTask_;

        FreeItem(ConnectionWrapper connectionWrapper) {
            this.connectionWrapper_ = connectionWrapper;
            this.timeoutTask_ = TimeoutManager.getInstance().addTimeoutTarget(this, ConnectionPoolImpl.this.timeout_, false);
        }

        public ConnectionWrapper getConnection() {
            return this.connectionWrapper_;
        }

        public void expired() {
            SLinkedList sLinkedList = ConnectionPoolImpl.this.freePool_;
            synchronized (sLinkedList) {
                ConnectionPoolImpl.this.freePool_.remove((Object)this);
            }
            this.timeoutTask_.cancel();
            this.connectionWrapper_.closeReally();
        }

        public void destroy() {
            this.timeoutTask_.cancel();
            this.timeoutTask_ = null;
            this.connectionWrapper_ = null;
        }
    }
}

