/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.RequestUtils;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.ClassUtil;

public class RequestProcessorUtil {
    private RequestProcessorUtil() {
    }

    public static synchronized RequestProcessor getRequestProcessor(ModuleConfig config, ServletContext context, ActionServlet actionServlet) throws ServletException {
        RequestProcessor processor = RequestProcessorUtil.getProcessorForModule(config, context);
        if (processor == null) {
            String processorClassName = config.getControllerConfig().getProcessorClass();
            Class requestProcessorClazz = ClassUtil.forName((String)processorClassName);
            S2Container container = SingletonS2ContainerFactory.getContainer();
            if (container.hasComponentDef((Object)requestProcessorClazz)) {
                processor = (RequestProcessor)container.getComponent((Object)requestProcessorClazz);
            }
            if (processor == null) {
                try {
                    processor = (RequestProcessor)RequestUtils.applicationInstance((String)processorClassName);
                }
                catch (Exception e) {
                    String message = "Cannot initialize RequestProcessor of class " + processorClassName + ": " + e;
                    throw new UnavailableException(message);
                }
            }
            processor.init(actionServlet, config);
            String key = "org.apache.struts.action.REQUEST_PROCESSOR" + config.getPrefix();
            context.setAttribute(key, (Object)processor);
        }
        return processor;
    }

    private static RequestProcessor getProcessorForModule(ModuleConfig config, ServletContext context) {
        String key = "org.apache.struts.action.REQUEST_PROCESSOR" + config.getPrefix();
        return (RequestProcessor)context.getAttribute(key);
    }
}

