package org.seasar.framework.container;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * R|[lgǗDIReĩC^[tF[XłB
 *
 * @author higa
 */
public interface S2Container {

	/**
     * L[w肵ăR|[lg擾܂B
     * L[̏ꍇAvR|[lgR|[lg
     * 擾܂B
     * L[NX܂̓C^[tF[X̏ꍇA
     * uR|[lg instanceof L[v
     * 𖞂R|[lg擾܂B
     *
     * @param componentKey R|[lg擾邽߂̃L[
     * @return R|[lg
     * @throws ComponentNotFoundRuntimeException R|[lgȂꍇ
     * @throws TooManyRegistrationRuntimeException OA܂͓NXɕ̃R|[lgo^Ăꍇ
     * @throws CyclicReferenceRuntimeException constructor injectionŃR|[lg̎QƂzĂꍇ
     */
	public Object getComponent(Object componentKey)
		throws
			ComponentNotFoundRuntimeException,
			TooManyRegistrationRuntimeException,
			CyclicReferenceRuntimeException;

	/**
     * OR|[lgɃZb^[ECWFNVA\bhEC
     * WFNVs܂B
     * OR|[lg̃NXL[ƂăR|[lg`擾܂B
     * instance[h"outer"ƒ`ꂽR|[lĝݗLłB
     * uR|[lg instanceof OR|[lg.getClass()v
     * 𖞂OR|[lg`𗘗p܂B
     *
     * @param outerComponent OR|[lg
     * @throws ClassUnmatchRuntimeException KOR|[lg`Ȃꍇ
     */
	public void injectDependency(Object outerComponent)
		throws ClassUnmatchRuntimeException;

	/**
     * OR|[lgɃZb^[ECWFNVA\bhEC
     * WFNVs܂B
     * componentClassL[ƂăR|[lg`擾܂B
     * instance[h"outer"ƒ`ꂽR|[lĝݗLłB
     * uR|[lg instanceof OR|[lgv
     * 𖞂OR|[lg`𗘗p܂B
     *
     * @param outerComponent OR|[lg
     * @param componentClass OR|[lg`̃L[ (NX)
     * @throws ClassUnmatchRuntimeException uOR|[lg instanceof 擾R|[lg̃NXvfalseԂꍇ
     */
	public void injectDependency(Object outerComponent, Class componentClass)
		throws ClassUnmatchRuntimeException;

	/**
     * OR|[lgɃZb^[ECWFNVA\bhEC
     * WFNVs܂B
     * componentClassL[ƂăR|[lg`擾܂B
     * instance[h"outer"ƒ`ꂽR|[lĝݗLłB
     * uR|[lg instanceof OR|[lgv
     * 𖞂OR|[lg`𗘗p܂B
     *
     * @param outerComponent OR|[lg
     * @param componentName OR|[lg`̃L[ (O)
     * @throws ClassUnmatchRuntimeException uOR|[lg instanceof 擾R|[lg̃NXvfalseԂꍇ
     */
	public void injectDependency(Object outerComponent, String componentName)
		throws ClassUnmatchRuntimeException;

	/**
     * IuWFNgR|[lgƂēo^܂B
     * L[̓IuWFNg̃NXɂȂ܂B
     *
     * @param component R|[lgƂēo^IuWFNg
     */
	public void register(Object component);
	
	/**
     * IuWFNg𖼑OtR|[lgƂēo^܂B
     *
     * @param component R|[lgƂēo^IuWFNg
     * @param componentName R|[lg
     */
	public void register(Object component, String componentName);

	/**
     * NXR|[lg`Ƃēo^܂B
     *
     * @param componentClass R|[lg̃NX
     */
	public void register(Class componentClass);

	/**
     * NX𖼑OtR|[lg`Ƃēo^܂B
     *
     * @param componentClass R|[lg̃NX
     * @param componentName R|[lg̖O
     */
	public void register(Class componentClass, String componentName);

	/**
     * R|[lg`o^܂B
     *
     * @param componentDef o^R|[lg`
     */
	public void register(ComponentDef componentDef);

	/**
     * R|[lg`̐擾܂B
     *
     * @return R|[lg`̐
     */
	public int getComponentDefSize();

	/**
     * ԍw肵ăR|[lg`擾܂B
     *
     * @param index ԍ
     * @return R|[lg`
     */
	public ComponentDef getComponentDef(int index);

	/**
     * w肵L[ɑΉR|[lg`擾܂B
     *
     * @param componentKey L[
     * @return R|[lg`
     * @throws ComponentNotFoundRuntimeException R|[lg`Ȃꍇ
     */
	public ComponentDef getComponentDef(Object componentKey)
		throws ComponentNotFoundRuntimeException;

	/**
     * w肵L[ɑΉR|[lg`ǂ肵܂B
     *
     * @param componentKey L[
     * @return ݂Ȃtrue
     */
	public boolean hasComponentDef(Object componentKey);
	
	/**
     * root̃ReiŁApathɑΉReiɃ[h
     * 邩Ԃ܂B
     *
     * @param path pX
     * @return [hĂȂtrue
     */
	public boolean hasDescendant(String path);
	
	/**
     * root̃ReiŁAw肵pXɑΉ郍[hς݂̃Rei擾܂B
     *
     * @param path pX
     * @return Rei
     * @throws ContainerNotRegisteredRuntimeException ReiȂꍇ
     */
	public S2Container getDescendant(String path)
		throws ContainerNotRegisteredRuntimeException;
	
	/**
     * root̃ReiɁA[hς݂̃Reio^܂B
     *
     * @param descendant [hς݂̃Rei
     */
	public void registerDescendant(S2Container descendant);

	/**
     * qReiinclude܂B
     *
     * @param child includeqRei
     */
	public void include(S2Container child);
	
	/**
     * qRei̐擾܂B
     *
     * @return qRei̐
     */
	public int getChildSize();
	
	/**
     * ԍw肵ĎqRei擾܂B
     *
     * @param index qRei̔ԍ
     * @return qRei
     */
	public S2Container getChild(int index);

	/**
     * Rei܂B
     * qReiꍇAqReiSďA܂B
     */
	public void init();

	/**
     * ReȉIȂ܂B
     * qReiꍇȀIsA
     * qReiSĂ̏Is܂B
     */
	public void destroy();
	
	/**
     * OԂ擾܂B
     *
     * @return O
     */
	public String getNamespace();
	
	/**
     * OԂZbg܂B
     *
     * @param namespace Zbg閼O
     */
	public void setNamespace(String namespace);
	
	/**
     * ݒt@C̃pX擾܂B
     *
     * @return ݒt@C̃pX
     */
	public String getPath();
	
	/**
     * ݒt@C̃pXZbg܂B
     *
     * @param path Zbgݒt@C̃pX
     */
	public void setPath(String path);

	/**
     * [g̃Rei擾܂B
     *
     * @return [g̃Rei
     */
	public S2Container getRoot();
	
	/**
     * [g̃ReiZbg܂B
     *
     * @param root Zbg郋[g̃Rei
     */
	public void setRoot(S2Container root);
	
	/**
     * NGXg擾܂B
     *
     * @return NGXg
     */
	public HttpServletRequest getRequest();
	
	/**
     * NGXgZbg܂BNGXgTheadLocalŊǗ܂B
     *
     * @param request Zbg郊NGXg
     */
	public void setRequest(HttpServletRequest request);
	
	/**
     * ZbV擾܂B
     *
     * @return ZbV
     */
	public HttpSession getSession();
	
	/**
     * X|X擾܂B
     *
     * @return X|X
     */
	public HttpServletResponse getResponse();
	
	/**
     * X|XZbg܂BX|XTheadLocalŊǗ܂B
     *
     * @param response Zbg郌X|X
     */
	public void setResponse(HttpServletResponse response);
	
	/**
     * T[ubgReLXg擾܂B
     *
     * @return T[ubgReLXg
     */
	public ServletContext getServletContext();
	
	/**
     * T[ubgReLXgZbg܂B
     *
     * @param servletContext ZbgT[ubgReLXg
     */
	public void setServletContext(ServletContext servletContext);
}
