package test.org.seasar.extension.j2ee;

import java.util.Hashtable;

import javax.naming.Context;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.extension.j2ee.JndiContext;

public class JndiContextTest extends TestCase {

	private static final String PATH =
		"test/org/seasar/extension/j2ee/jndi.dicon";
	private Context ctx_;

	public JndiContextTest(String name) {
		super(name);
	}

	public void testLookup() throws Exception {
		assertNotNull("1", ctx_.lookup("jndi.transactionManager"));
		assertNotNull("2", ctx_.lookup("jndi.dataSource"));
	}

	protected void setUp() throws Exception {
		Hashtable env = new Hashtable();
		env.put(Context.PROVIDER_URL, PATH);
		ctx_ = new JndiContext(env);
	}

	protected void tearDown() throws Exception {
		ctx_.close();
	}

	public static Test suite() {
		return new TestSuite(JndiContextTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { JndiContextTest.class.getName()});
	}
}