/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.StringUtil;

public class S2ContainerServlet
extends HttpServlet {
    public static final String CONFIG_PATH_KEY = "configPath";
    public static final String DEBUG_KEY = "debug";
    public static final String COMMAND = "command";
    public static final String RESTART = "restart";
    private boolean debug_;

    public void init() {
        String configPath = null;
        String debugStr = null;
        ServletConfig servletConfig = this.getServletConfig();
        if (servletConfig != null) {
            configPath = servletConfig.getInitParameter(CONFIG_PATH_KEY);
            debugStr = servletConfig.getInitParameter(DEBUG_KEY);
        }
        if (!StringUtil.isEmpty(configPath)) {
            SingletonS2ContainerFactory.setConfigPath(configPath);
        }
        if (!StringUtil.isEmpty(debugStr)) {
            this.debug_ = Boolean.valueOf(debugStr);
        }
        SingletonS2ContainerFactory.setServletContext(this.getServletContext());
        SingletonS2ContainerFactory.init();
    }

    public void destroy() {
        SingletonS2ContainerFactory.destroy();
    }

    public static S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String command = request.getParameter(COMMAND);
        if (this.debug_ && command != null && RESTART.equalsIgnoreCase(command)) {
            this.destroy();
            this.init();
            response.getWriter().write("S2ContainerServlet is restarted.");
        } else {
            response.getWriter().write("S2ContainerServlet is running.");
        }
    }
}

