/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

public class Servlet
extends HttpServlet {
    static final int BUFFER_SIZE = 256;
    String dbType;
    String dbPath;
    String errorStr;
    RowOutputBinary rowOut = new RowOutputBinary(256);
    RowInputBinary rowIn = new RowInputBinary(this.rowOut);
    private static long lModified = 0L;
    private static int iQueries;

    public void init(ServletConfig servletConfig) {
        try {
            super.init(servletConfig);
        }
        catch (ServletException servletException) {
            this.log(servletException.getMessage());
        }
        String string = this.getInitParameter("hsqldb.server.database");
        if (string == null) {
            string = ".";
        }
        HsqlProperties hsqlProperties = DatabaseManager.parseURL(string, false);
        this.log("Database filename = " + string);
        if (hsqlProperties == null) {
            this.errorStr = "Bad Database name";
        } else {
            this.dbPath = hsqlProperties.getProperty("database");
            this.dbType = hsqlProperties.getProperty("connection_type");
            try {
                DatabaseManager.getDatabase(this.dbType, this.dbPath, false, hsqlProperties);
            }
            catch (HsqlException hsqlException) {
                this.errorStr = hsqlException.getMessage();
            }
        }
        this.log(this.errorStr);
        this.log("Initialization completed.");
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        return lModified++;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = httpServletRequest.getQueryString();
        if (string == null || string.length() == 0) {
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setHeader("Pragma", "no-cache");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<html><head><title>HSQL Database Engine Servlet</title>");
            printWriter.println("</head><body><h1>HSQL Database Engine Servlet</h1>");
            printWriter.println("The servlet is running.<p>");
            if (this.errorStr == null) {
                printWriter.println("The database is also running.<p>");
                printWriter.println("Database name: " + this.dbType + this.dbPath + "<p>");
                printWriter.println("Queries processed: " + iQueries + "<p>");
            } else {
                printWriter.println("<h2>The database is not running!</h2>");
                printWriter.println("The error message is:<p>");
                printWriter.println(this.errorStr);
            }
            printWriter.println("</body></html>");
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            Result result;
            Session session;
            DataInputStream dataInputStream = new DataInputStream((InputStream)httpServletRequest.getInputStream());
            Result result2 = Result.read(this.rowIn, dataInputStream);
            if (result2.iMode == 65543) {
                try {
                    session = DatabaseManager.newSession(this.dbType, this.dbPath, result2.getMainString(), result2.getSubString(), true, null);
                    result = new Result(1);
                    result.sessionID = session.getId();
                }
                catch (HsqlException hsqlException) {
                    result = new Result(hsqlException, null);
                }
            } else {
                session = DatabaseManager.getSession(this.dbType, this.dbPath, result2.sessionID);
                result = session.execute(result2);
            }
            this.rowOut.reset();
            result.write(this.rowOut);
            httpServletResponse.setContentType("application/octet-stream");
            httpServletResponse.setContentLength(this.rowOut.size());
            session = httpServletResponse.getOutputStream();
            session.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
            session.flush();
            session.close();
            ++iQueries;
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }
}

