/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.lang.reflect.Field;
import java.sql.DatabaseMetaData;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.Dbms;
import org.seasar.dao.IdentifierGenerator;
import org.seasar.dao.PrimaryKeyNotFoundRuntimeException;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.id.IdentifierGeneratorFactory;
import org.seasar.dao.impl.DtoMetaDataImpl;
import org.seasar.dao.impl.RelationPropertyTypeImpl;
import org.seasar.extension.jdbc.ColumnNotFoundRuntimeException;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.PropertyNotFoundRuntimeException;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.DatabaseMetaDataUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.StringUtil;

public class BeanMetaDataImpl
extends DtoMetaDataImpl
implements BeanMetaData {
    private String tableName_;
    private Map propertyTypesByColumnName_ = new CaseInsensitiveMap();
    private List relationPropertyTypes_ = new ArrayList();
    private String[] primaryKeys_ = new String[0];
    private String autoInsertSql_;
    private String autoUpdateSql_;
    private String autoDeleteSql_;
    private String autoSelectList_;
    private boolean relation_;
    private IdentifierGenerator identifierGenerator_;

    public BeanMetaDataImpl(Class beanClass, DatabaseMetaData dbMetaData, Dbms dbms) {
        this(beanClass, dbMetaData, dbms, false);
    }

    public BeanMetaDataImpl(Class beanClass, DatabaseMetaData dbMetaData, Dbms dbms, boolean relation) {
        this.setBeanClass(beanClass);
        this.relation_ = relation;
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)beanClass);
        this.setupTableName(beanDesc);
        this.setupProperty(beanDesc, dbMetaData, dbms);
        this.setupDatabaseMetaData(beanDesc, dbMetaData, dbms);
    }

    public String getTableName() {
        return this.tableName_;
    }

    public PropertyType getVersionNoPropertyType() throws PropertyNotFoundRuntimeException {
        return this.getPropertyType("versionNo");
    }

    public PropertyType getTimestampPropertyType() throws PropertyNotFoundRuntimeException {
        return this.getPropertyType("timestamp");
    }

    public PropertyType getPropertyTypeByColumnName(String columnName) throws ColumnNotFoundRuntimeException {
        PropertyType propertyType = (PropertyType)this.propertyTypesByColumnName_.get(columnName);
        if (propertyType == null) {
            throw new ColumnNotFoundRuntimeException(this.tableName_, columnName);
        }
        return propertyType;
    }

    public PropertyType getPropertyTypeByAliasName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return this.getPropertyTypeByColumnName(alias);
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            throw new ColumnNotFoundRuntimeException(this.tableName_, alias);
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            throw new ColumnNotFoundRuntimeException(this.tableName_, alias);
        }
        RelationPropertyType rpt = this.getRelationPropertyType(relno);
        if (!rpt.getBeanMetaData().hasPropertyTypeByColumnName(columnName)) {
            throw new ColumnNotFoundRuntimeException(this.tableName_, alias);
        }
        return rpt.getBeanMetaData().getPropertyTypeByColumnName(columnName);
    }

    public boolean hasPropertyTypeByColumnName(String columnName) {
        return this.propertyTypesByColumnName_.get(columnName) != null;
    }

    public boolean hasPropertyTypeByAliasName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return true;
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            return false;
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            return false;
        }
        if (relno >= this.getRelationPropertyTypeSize()) {
            return false;
        }
        RelationPropertyType rpt = this.getRelationPropertyType(relno);
        return rpt.getBeanMetaData().hasPropertyTypeByColumnName(columnName);
    }

    public boolean hasVersionNoPropertyType() {
        return this.hasPropertyType("versionNo");
    }

    public boolean hasTimestampPropertyType() {
        return this.hasPropertyType("timestamp");
    }

    public String convertFullColumnName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return String.valueOf(this.tableName_) + "." + alias;
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            throw new ColumnNotFoundRuntimeException(this.tableName_, alias);
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            throw new ColumnNotFoundRuntimeException(this.tableName_, alias);
        }
        RelationPropertyType rpt = this.getRelationPropertyType(relno);
        if (!rpt.getBeanMetaData().hasPropertyTypeByColumnName(columnName)) {
            throw new ColumnNotFoundRuntimeException(this.tableName_, alias);
        }
        return String.valueOf(rpt.getPropertyName()) + "." + columnName;
    }

    public int getRelationPropertyTypeSize() {
        return this.relationPropertyTypes_.size();
    }

    public RelationPropertyType getRelationPropertyType(int index) {
        return (RelationPropertyType)this.relationPropertyTypes_.get(index);
    }

    public RelationPropertyType getRelationPropertyType(String propertyName) throws PropertyNotFoundRuntimeException {
        int i = 0;
        while (i < this.getRelationPropertyTypeSize()) {
            RelationPropertyType rpt = (RelationPropertyType)this.relationPropertyTypes_.get(i);
            if (rpt != null && rpt.getPropertyName().equalsIgnoreCase(propertyName)) {
                return rpt;
            }
            ++i;
        }
        throw new PropertyNotFoundRuntimeException(this.getBeanClass(), propertyName);
    }

    private void setupTableName(BeanDesc beanDesc) {
        if (beanDesc.hasField("TABLE")) {
            Field field = beanDesc.getField("TABLE");
            this.tableName_ = (String)FieldUtil.get((Field)field, null);
        } else {
            this.tableName_ = ClassUtil.getShortClassName((Class)this.getBeanClass());
        }
    }

    private void setupProperty(BeanDesc beanDesc, DatabaseMetaData dbMetaData, Dbms dbms) {
        int i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            String idKey;
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            PropertyType pt = null;
            String relnoKey = String.valueOf(pd.getPropertyName()) + "_RELNO";
            if (beanDesc.hasField(relnoKey)) {
                if (!this.relation_) {
                    RelationPropertyType rpt = this.createRelationPropertyType(beanDesc, pd, relnoKey, dbMetaData, dbms);
                    this.addRelationPropertyType(rpt);
                }
            } else {
                pt = this.createPropertyType(beanDesc, pd);
                this.addPropertyType(pt);
            }
            if (this.identifierGenerator_ == null && beanDesc.hasField(idKey = String.valueOf(pd.getPropertyName()) + "_ID")) {
                Field field = beanDesc.getField(idKey);
                String idAnnotation = (String)FieldUtil.get((Field)field, null);
                this.identifierGenerator_ = IdentifierGeneratorFactory.createIdentifierGenerator(pd.getPropertyName(), dbms, idAnnotation);
                this.primaryKeys_ = new String[]{pd.getPropertyName()};
                pt.setPrimaryKey(true);
            }
            ++i;
        }
    }

    private void setupDatabaseMetaData(BeanDesc beanDesc, DatabaseMetaData dbMetaData, Dbms dbms) {
        this.setupPrimaryKey(dbMetaData, dbms);
        this.setupPropertyPersistent(beanDesc, dbMetaData);
        this.setupAutoInsertSql();
        this.setupAutoUpdateSql();
        this.setupAutoDeleteSql();
    }

    private void setupPrimaryKey(DatabaseMetaData dbMetaData, Dbms dbms) {
        if (this.identifierGenerator_ == null) {
            ArrayList<String> pkeyList = new ArrayList<String>();
            Set primaryKeySet = DatabaseMetaDataUtil.getPrimaryKeySet((DatabaseMetaData)dbMetaData, (String)this.tableName_);
            int i = 0;
            while (i < this.getPropertyTypeSize()) {
                PropertyType pt = this.getPropertyType(i);
                if (primaryKeySet.contains(pt.getColumnName())) {
                    pt.setPrimaryKey(true);
                    pkeyList.add(pt.getColumnName());
                } else {
                    pt.setPrimaryKey(false);
                }
                ++i;
            }
            this.primaryKeys_ = pkeyList.toArray(new String[pkeyList.size()]);
            this.identifierGenerator_ = IdentifierGeneratorFactory.createIdentifierGenerator(null, dbms);
        }
    }

    private void setupPropertyPersistent(BeanDesc beanDesc, DatabaseMetaData dbMetaData) {
        if (beanDesc.hasField("NO_PERSISTENT_COLUMNS")) {
            Field field = beanDesc.getField("NO_PERSISTENT_COLUMNS");
            String str = (String)FieldUtil.get((Field)field, null);
            String[] columns = StringUtil.split((String)str, (String)", ");
            int i = 0;
            while (i < columns.length) {
                PropertyType pt = this.getPropertyType(columns[i].trim());
                pt.setPersistent(false);
                ++i;
            }
        } else {
            Set columnSet = DatabaseMetaDataUtil.getColumnSet((DatabaseMetaData)dbMetaData, (String)this.tableName_);
            int i = 0;
            while (i < this.getPropertyTypeSize()) {
                PropertyType pt = this.getPropertyType(i);
                if (!columnSet.contains(pt.getColumnName())) {
                    pt.setPersistent(false);
                }
                ++i;
            }
        }
    }

    private RelationPropertyType createRelationPropertyType(BeanDesc beanDesc, PropertyDesc propertyDesc, String relnoKey, DatabaseMetaData dbMetaData, Dbms dbms) {
        Field field = beanDesc.getField(relnoKey);
        String[] myKeys = new String[]{};
        String[] yourKeys = new String[]{};
        int relno = FieldUtil.getInt((Field)field, null);
        String relkeysKey = String.valueOf(propertyDesc.getPropertyName()) + "_RELKEYS";
        if (beanDesc.hasField(relkeysKey)) {
            Field field2 = beanDesc.getField(relkeysKey);
            String relkeys = (String)FieldUtil.get((Field)field2, null);
            StringTokenizer st = new StringTokenizer(relkeys, " \t\n\r\f,");
            ArrayList<String> myKeyList = new ArrayList<String>();
            ArrayList<String> yourKeyList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int index = token.indexOf(58);
                if (index > 0) {
                    myKeyList.add(token.substring(0, index));
                    yourKeyList.add(token.substring(index + 1));
                    continue;
                }
                myKeyList.add(token);
                yourKeyList.add(token);
            }
            myKeys = myKeyList.toArray(new String[myKeyList.size()]);
            yourKeys = yourKeyList.toArray(new String[yourKeyList.size()]);
        }
        RelationPropertyTypeImpl rpt = new RelationPropertyTypeImpl(propertyDesc, relno, myKeys, yourKeys, dbMetaData, dbms);
        return rpt;
    }

    private void addRelationPropertyType(RelationPropertyType rpt) {
        int i = this.relationPropertyTypes_.size();
        while (i <= rpt.getRelationNo()) {
            this.relationPropertyTypes_.add(null);
            ++i;
        }
        this.relationPropertyTypes_.set(rpt.getRelationNo(), rpt);
    }

    protected void addPropertyType(PropertyType propertyType) {
        super.addPropertyType(propertyType);
        this.propertyTypesByColumnName_.put(propertyType.getColumnName(), propertyType);
    }

    public int getPrimaryKeySize() {
        return this.primaryKeys_.length;
    }

    public String getPrimaryKey(int index) {
        return this.primaryKeys_[index];
    }

    public IdentifierGenerator getIdentifierGenerator() {
        return this.identifierGenerator_;
    }

    private void setupAutoInsertSql() {
        StringBuffer buf = new StringBuffer(100);
        buf.append("INSERT INTO ");
        buf.append(this.getTableName());
        buf.append(" (");
        int persistentColumnCount = 0;
        int i = 0;
        while (i < this.getPropertyTypeSize()) {
            PropertyType pt = this.getPropertyType(i);
            if (pt.isPersistent() && (!pt.isPrimaryKey() || this.identifierGenerator_.isSelfGererate())) {
                ++persistentColumnCount;
                buf.append(pt.getColumnName());
                buf.append(", ");
            }
            ++i;
        }
        buf.setLength(buf.length() - 2);
        buf.append(") VALUES(");
        i = 0;
        while (i < persistentColumnCount) {
            buf.append("?, ");
            ++i;
        }
        buf.setLength(buf.length() - 2);
        buf.append(")");
        this.autoInsertSql_ = buf.toString();
    }

    protected void setupAutoUpdateSql() {
        if (this.getPrimaryKeySize() == 0) {
            return;
        }
        StringBuffer buf = new StringBuffer(100);
        buf.append("UPDATE ");
        buf.append(this.getTableName());
        buf.append(" SET ");
        int i = 0;
        while (i < this.getPropertyTypeSize()) {
            PropertyType pt = this.getPropertyType(i);
            if (pt.isPersistent() && !pt.isPrimaryKey()) {
                if (pt.getPropertyName().equals("versionNo")) {
                    buf.append(pt.getColumnName());
                    buf.append(" = ");
                    buf.append(pt.getColumnName());
                    buf.append(" + 1, ");
                } else {
                    buf.append(pt.getColumnName());
                    buf.append(" = ?, ");
                }
            }
            ++i;
        }
        buf.setLength(buf.length() - 2);
        this.setupAutoUpdateWhere(buf);
        this.autoUpdateSql_ = buf.toString();
    }

    protected void setupAutoDeleteSql() {
        if (this.getPrimaryKeySize() == 0) {
            return;
        }
        StringBuffer buf = new StringBuffer(100);
        buf.append("DELETE FROM ");
        buf.append(this.getTableName());
        this.setupAutoUpdateWhere(buf);
        this.autoDeleteSql_ = buf.toString();
    }

    protected void setupAutoUpdateWhere(StringBuffer buf) {
        buf.append(" WHERE ");
        int i = 0;
        while (i < this.getPrimaryKeySize()) {
            buf.append(this.getPrimaryKey(i));
            buf.append(" = ? AND ");
            ++i;
        }
        buf.setLength(buf.length() - 5);
        if (this.hasVersionNoPropertyType()) {
            PropertyType pt = this.getVersionNoPropertyType();
            buf.append(" AND ");
            buf.append(pt.getColumnName());
            buf.append(" = ?");
        }
        if (this.hasTimestampPropertyType()) {
            PropertyType pt = this.getTimestampPropertyType();
            buf.append(" AND ");
            buf.append(pt.getColumnName());
            buf.append(" = ?");
        }
    }

    public String getAutoInsertSql() {
        return this.autoInsertSql_;
    }

    public String getAutoUpdateSql() {
        if (this.autoUpdateSql_ == null) {
            throw new PrimaryKeyNotFoundRuntimeException(this.getBeanClass());
        }
        return this.autoUpdateSql_;
    }

    public String getAutoDeleteSql() {
        if (this.autoDeleteSql_ == null) {
            throw new PrimaryKeyNotFoundRuntimeException(this.getBeanClass());
        }
        return this.autoDeleteSql_;
    }

    public String getAutoSelectList() {
        if (this.autoSelectList_ != null) {
            return this.autoSelectList_;
        }
        this.setupAutoSelectList();
        return this.autoSelectList_;
    }

    private synchronized void setupAutoSelectList() {
        if (this.autoSelectList_ != null) {
            return;
        }
        StringBuffer buf = new StringBuffer(100);
        buf.append("SELECT ");
        int i = 0;
        while (i < this.getPropertyTypeSize()) {
            PropertyType pt = this.getPropertyType(i);
            if (pt.isPersistent()) {
                buf.append(this.tableName_);
                buf.append(".");
                buf.append(pt.getColumnName());
                buf.append(", ");
            }
            ++i;
        }
        i = 0;
        while (i < this.getRelationPropertyTypeSize()) {
            RelationPropertyType rpt = this.getRelationPropertyType(i);
            BeanMetaData bmd = rpt.getBeanMetaData();
            int j = 0;
            while (j < bmd.getPropertyTypeSize()) {
                PropertyType pt = bmd.getPropertyType(j);
                if (pt.isPersistent()) {
                    String columnName = pt.getColumnName();
                    buf.append(rpt.getPropertyName());
                    buf.append(".");
                    buf.append(columnName);
                    buf.append(" AS ");
                    buf.append(pt.getColumnName()).append("_").append(rpt.getRelationNo());
                    buf.append(", ");
                }
                ++j;
            }
            ++i;
        }
        buf.setLength(buf.length() - 2);
        this.autoSelectList_ = buf.toString();
    }

    public Object[] getAutoInsertBindVariables(Object bean) {
        ArrayList<Object> variables = new ArrayList<Object>();
        int i = 0;
        while (i < this.getPropertyTypeSize()) {
            PropertyType pt = this.getPropertyType(i);
            if (pt.isPersistent() && (!pt.isPrimaryKey() || this.identifierGenerator_.isSelfGererate())) {
                if (pt.getPropertyName().equalsIgnoreCase("timestamp")) {
                    Timestamp now = new Timestamp(new Date().getTime());
                    variables.add(now);
                } else {
                    variables.add(pt.getPropertyDesc().getValue(bean));
                }
            }
            ++i;
        }
        return variables.toArray();
    }

    public Object[] getAutoUpdateBindVariables(Object bean) {
        ArrayList<Object> bindVariables = new ArrayList<Object>();
        int i = 0;
        while (i < this.getPropertyTypeSize()) {
            PropertyType pt = this.getPropertyType(i);
            if (pt.isPersistent() && !pt.isPrimaryKey() && !pt.getPropertyName().equals("versionNo")) {
                if (pt.getPropertyName().equalsIgnoreCase("timestamp")) {
                    Timestamp now = new Timestamp(new Date().getTime());
                    bindVariables.add(now);
                } else {
                    bindVariables.add(pt.getPropertyDesc().getValue(bean));
                }
            }
            ++i;
        }
        this.addAutoUpdateWhereBindVariables(bindVariables, bean);
        return bindVariables.toArray();
    }

    public Object[] getAutoDeleteBindVariables(Object bean) {
        ArrayList bindVariables = new ArrayList();
        this.addAutoUpdateWhereBindVariables(bindVariables, bean);
        return bindVariables.toArray();
    }

    private void addAutoUpdateWhereBindVariables(List bindVariables, Object bean) {
        int i = 0;
        while (i < this.getPrimaryKeySize()) {
            PropertyType pt = this.getPropertyTypeByColumnName(this.getPrimaryKey(i));
            bindVariables.add(pt.getPropertyDesc().getValue(bean));
            ++i;
        }
        if (this.hasVersionNoPropertyType()) {
            PropertyType pt = this.getVersionNoPropertyType();
            bindVariables.add(pt.getPropertyDesc().getValue(bean));
        }
        if (this.hasTimestampPropertyType()) {
            PropertyType pt = this.getTimestampPropertyType();
            bindVariables.add(pt.getPropertyDesc().getValue(bean));
        }
    }

    public boolean isRelation() {
        return this.relation_;
    }
}

