/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.extension.dataset.DataReader;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataSetConstants;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.DataSetImpl;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.Base64Util;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.TimestampConversionUtil;

public class XlsReader
implements DataReader,
DataSetConstants {
    private DataSet dataSet_;
    private HSSFWorkbook workbook_;
    private HSSFDataFormat dataFormat_;

    public XlsReader(String path) {
        this(ResourceUtil.getResourceAsStream((String)path));
    }

    public XlsReader(InputStream in) {
        try {
            this.workbook_ = new HSSFWorkbook(in);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
        this.dataFormat_ = this.workbook_.createDataFormat();
        this.dataSet_ = new DataSetImpl();
        int i = 0;
        while (i < this.workbook_.getNumberOfSheets()) {
            this.createTable(this.workbook_.getSheetName(i), this.workbook_.getSheetAt(i));
            ++i;
        }
    }

    public DataSet read() {
        return this.dataSet_;
    }

    private DataTable createTable(String sheetName, HSSFSheet sheet) {
        DataTable table = this.dataSet_.addTable(sheetName);
        int rowCount = sheet.getLastRowNum();
        if (rowCount >= 0) {
            this.setupColumns(table, sheet.getRow(0));
            if (rowCount > 0) {
                this.setupRows(table, sheet);
            }
        }
        return table;
    }

    private void setupColumns(DataTable table, HSSFRow row) {
        String nameCellValue;
        HSSFCell nameCell;
        int i = 0;
        while ((nameCell = row.getCell((short)i)) != null && (nameCellValue = nameCell.getStringCellValue().trim()).length() != 0) {
            table.addColumn(nameCellValue);
            ++i;
        }
    }

    private void setupRows(DataTable table, HSSFSheet sheet) {
        HSSFRow row;
        int i = 1;
        while ((row = sheet.getRow((int)((short)i))) != null) {
            this.setupRow(table, row);
            ++i;
        }
    }

    private void setupRow(DataTable table, HSSFRow row) {
        DataRow dataRow = table.addRow();
        int i = 0;
        while (i < table.getColumnSize()) {
            HSSFCell cell = row.getCell((short)i);
            Object value = this.getValue(cell);
            dataRow.setValue(i, value);
            ++i;
        }
    }

    public boolean isCellBase64Formatted(HSSFCell cell) {
        HSSFCellStyle cs = cell.getCellStyle();
        short dfNum = cs.getDataFormat();
        return "\\B\\:@".equals(this.dataFormat_.getFormat(dfNum));
    }

    public boolean isCellDateFormatted(HSSFCell cell) {
        HSSFCellStyle cs = cell.getCellStyle();
        short dfNum = cs.getDataFormat();
        String format = this.dataFormat_.getFormat(dfNum);
        if (StringUtil.isEmpty((String)format)) {
            return false;
        }
        return format.indexOf(47) > 0 || format.indexOf(121) > 0 || format.indexOf(109) > 0 || format.indexOf(100) > 0;
    }

    public Object getValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 0: {
                if (this.isCellDateFormatted(cell)) {
                    return TimestampConversionUtil.toTimestamp((Object)cell.getDateCellValue());
                }
                return new BigDecimal(cell.getNumericCellValue());
            }
            case 1: {
                String s = cell.getStringCellValue();
                if (s != null) {
                    s = StringUtil.rtrim((String)s);
                }
                if ("".equals(s)) {
                    s = null;
                }
                if (this.isCellBase64Formatted(cell)) {
                    return Base64Util.decode((String)s);
                }
                return s;
            }
        }
        return null;
    }
}

