package test.org.seasar.dao.impl;

import org.seasar.dao.impl.BeanMetaDataImpl;
import org.seasar.dao.impl.InsertBatchAutoStaticCommand;
import org.seasar.dao.unit.S2DaoTestCase;

public class InsertBatchAutoStaticCommandTest extends S2DaoTestCase {

	public InsertBatchAutoStaticCommandTest(String arg0) {
		super(arg0);
	}

	public void testExecuteTx() throws Exception {
		InsertBatchAutoStaticCommand cmd = new InsertBatchAutoStaticCommand(
				getDataSource(), new BeanMetaDataImpl(Employee.class,
						getDatabaseMetaData(), getDbms()));
		Employee emp = new Employee();
		emp.setEmpno(99);
		emp.setEname("hoge");
		Employee emp2 = new Employee();
		emp2.setEmpno(98);
		emp2.setEname("hoge2");
		Integer count = (Integer) cmd.execute(new Object[] { new Employee[] {
				emp, emp2 } });
		assertEquals("1", new Integer(2), count);
	}

	public void setUp() {
		include("j2ee.dicon");
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(InsertBatchAutoStaticCommandTest.class);
	}

}