package org.seasar.struts;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.util.MessageResources;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.struts.action.ActionFactory;

/**
 * @see org.seasar.struts.action.ActionFactory
 * @deprecated will delete it by the version of 1.2.X or more. 
 * @author higa
 * @author Satoshi Kimura
 */
public final class ActionUtil {

    private ActionUtil() {
    }

    private static ActionFactory getActionCreator() {
        S2Container container = SingletonS2ContainerFactory.getContainer();
        return (ActionFactory) container.getComponent(ActionFactory.class);
    }

    /**
     * @see ActionFactory#getActionWithClassName(String, ActionServlet)
     */
    public static Action createActionWithClassName(String className, ActionServlet servlet) {
        return getActionCreator().getActionWithClassName(className, servlet);
    }

    /**
     * @see ActionFactory#getActionWithComponentName(String, ActionServlet)
     */
    public static Action createActionWithComponentName(String componentName, ActionServlet servlet)
            throws ComponentNotFoundRuntimeException {
        return getActionCreator().getActionWithComponentName(componentName, servlet);
    }

    /**
     * @see ActionFactory#processActionCreate(HttpServletRequest, HttpServletResponse, ActionMapping, Log,
     *      MessageResources, ActionServlet)
     */
    public static Action processActionCreate(HttpServletRequest request, HttpServletResponse response,
            ActionMapping mapping, Log log, MessageResources internal, ActionServlet servlet) throws IOException {
        return getActionCreator().processActionCreate(request, response, mapping, log, internal, servlet);
    }
    /**
     * @see ActionFactory#getActionInstance(HttpServletRequest, HttpServletResponse, ActionMapping, Log,
     *      MessageResources, ActionServlet)
     */
    public static Object getActionInstance(HttpServletRequest request, HttpServletResponse response,
            ActionMapping mapping, Log log, MessageResources internal, ActionServlet servlet) throws IOException {
        return getActionCreator().getActionInstance(request, response, mapping, log, internal, servlet);
    }

}