/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.lifecycle;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.jsf.component.S2UIViewRoot;
import org.seasar.jsf.util.ExternalContextUtil;

public class LifecycleImpl
extends Lifecycle {
    private static final String VIEW_ID_ATTR;
    private PhaseListener[] phaseListeners = new PhaseListener[0];
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.jsf.lifecycle.LifecycleImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        VIEW_ID_ATTR = String.valueOf(clazz.getName()) + ".VIEW_ID";
    }

    public void execute(FacesContext context) throws FacesException {
        boolean postback = this.restoreView(context);
        if (this.isFinished(context)) {
            return;
        }
        this.applyRequestValues(context);
        if (this.isFinished(context)) {
            return;
        }
        if (postback || this.hasEvent(context)) {
            this.processValidations(context);
            if (this.isFinished(context)) {
                return;
            }
        }
        this.updateModelValues(context);
        if (this.isFinished(context)) {
            return;
        }
        this.invokeApplication(context);
    }

    protected boolean restoreView(FacesContext context) throws FacesException {
        this.beforePhase(context, PhaseId.RESTORE_VIEW);
        ExternalContext externalContext = context.getExternalContext();
        String viewId = ExternalContextUtil.getViewId(externalContext);
        Application application = context.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        UIViewRoot viewRoot = viewHandler.restoreView(context, viewId);
        if (viewRoot == null) {
            viewRoot = viewHandler.createView(context, viewId);
            context.renderResponse();
        }
        String previousViewId = this.getViewIdFromSession(externalContext);
        context.setViewRoot(viewRoot);
        this.saveViewIdToSession(externalContext, viewId);
        this.setValid(context, (UIComponent)viewRoot);
        if (externalContext.getRequestParameterMap().isEmpty()) {
            context.renderResponse();
        }
        this.afterPhase(context, PhaseId.RESTORE_VIEW);
        return viewId.equals(previousViewId);
    }

    protected void applyRequestValues(FacesContext context) throws FacesException {
        this.beforePhase(context, PhaseId.APPLY_REQUEST_VALUES);
        context.getViewRoot().processDecodes(context);
        this.afterPhase(context, PhaseId.APPLY_REQUEST_VALUES);
    }

    protected void processValidations(FacesContext context) throws FacesException {
        this.beforePhase(context, PhaseId.PROCESS_VALIDATIONS);
        context.getViewRoot().processValidators(context);
        this.afterPhase(context, PhaseId.PROCESS_VALIDATIONS);
    }

    protected void updateModelValues(FacesContext context) throws FacesException {
        this.beforePhase(context, PhaseId.UPDATE_MODEL_VALUES);
        context.getViewRoot().processUpdates(context);
        this.afterPhase(context, PhaseId.UPDATE_MODEL_VALUES);
    }

    protected void invokeApplication(FacesContext context) throws FacesException {
        this.beforePhase(context, PhaseId.INVOKE_APPLICATION);
        context.getViewRoot().processApplication(context);
        this.afterPhase(context, PhaseId.INVOKE_APPLICATION);
    }

    public void render(FacesContext context) throws FacesException {
        if (context.getResponseComplete()) {
            return;
        }
        this.beforePhase(context, PhaseId.RENDER_RESPONSE);
        Application application = context.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        try {
            viewHandler.renderView(context, context.getViewRoot());
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        this.afterPhase(context, PhaseId.RENDER_RESPONSE);
    }

    protected String getViewIdFromSession(ExternalContext externalContext) {
        return (String)externalContext.getSessionMap().get(VIEW_ID_ATTR);
    }

    protected void saveViewIdToSession(ExternalContext externalContext, String viewId) {
        externalContext.getSessionMap().put(VIEW_ID_ATTR, viewId);
    }

    protected void setValid(FacesContext context, UIComponent component) {
        Iterator i = component.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent child = (UIComponent)i.next();
            if (child instanceof UIInput) {
                ((UIInput)child).setValid(true);
            }
            this.setValid(context, child);
        }
    }

    protected boolean isFinished(FacesContext context) throws FacesException {
        return context.getResponseComplete() || context.getRenderResponse();
    }

    public void addPhaseListener(PhaseListener listener) {
        this.phaseListeners = (PhaseListener[])ArrayUtil.add((Object[])this.phaseListeners, (Object)listener);
    }

    public void removePhaseListener(PhaseListener listener) {
        this.phaseListeners = (PhaseListener[])ArrayUtil.remove((Object[])this.phaseListeners, (Object)listener);
    }

    public PhaseListener[] getPhaseListeners() {
        return this.phaseListeners;
    }

    protected void beforePhase(FacesContext context, PhaseId phaseId) {
        int i = 0;
        while (i < this.phaseListeners.length) {
            PhaseListener listener = this.phaseListeners[i];
            if (this.isTargetListener(listener, phaseId)) {
                listener.beforePhase(new PhaseEvent(context, phaseId, (Lifecycle)this));
            }
            ++i;
        }
    }

    protected void afterPhase(FacesContext context, PhaseId phaseId) {
        int i = 0;
        while (i < this.phaseListeners.length) {
            PhaseListener listener = this.phaseListeners[i];
            if (this.isTargetListener(listener, phaseId)) {
                listener.afterPhase(new PhaseEvent(context, phaseId, (Lifecycle)this));
            }
            ++i;
        }
    }

    protected boolean isTargetListener(PhaseListener listener, PhaseId phaseId) {
        int listenerOrdinal = listener.getPhaseId().getOrdinal();
        return listenerOrdinal == PhaseId.ANY_PHASE.getOrdinal() || listenerOrdinal == phaseId.getOrdinal();
    }

    protected boolean hasEvent(FacesContext context) {
        S2UIViewRoot viewRoot = (S2UIViewRoot)context.getViewRoot();
        return viewRoot.getEventSize() > 0;
    }
}

