/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import net.sourceforge.myfaces.component.UserRoleUtils;
import net.sourceforge.myfaces.custom.radio.HtmlRadio;
import net.sourceforge.myfaces.renderkit.RendererUtils;
import net.sourceforge.myfaces.renderkit.html.HtmlRadioRendererBase;

public class HtmlRadioRenderer
extends HtmlRadioRendererBase {
    private static final String LAYOUT_SPREAD = "spread";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (component instanceof HtmlRadio) {
            this.renderRadio(context, (HtmlRadio)component);
        } else if (component instanceof UISelectOne) {
            String layout = this.getLayout(component);
            if (layout != null && layout.equals(LAYOUT_SPREAD)) {
                return;
            }
            super.encodeEnd(context, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    private void renderRadio(FacesContext facesContext, HtmlRadio radio) throws IOException {
        Converter converter;
        String forAttr = radio.getFor();
        if (forAttr == null) {
            throw new IllegalStateException("mandatory attribute 'for'");
        }
        int index = radio.getIndex();
        if (index < 0) {
            throw new IllegalStateException("positive index must be given");
        }
        UIComponent uiComponent = radio.findComponent(forAttr);
        if (uiComponent == null) {
            throw new IllegalStateException("Could not find component '" + forAttr + "' (calling findComponent on component '" + radio.getClientId(facesContext) + "')");
        }
        if (!(uiComponent instanceof UISelectOne)) {
            throw new IllegalStateException("UISelectOne expected");
        }
        UISelectOne uiSelectOne = (UISelectOne)uiComponent;
        List selectItemList = RendererUtils.getSelectItemList(uiSelectOne);
        if (index >= selectItemList.size()) {
            throw new IndexOutOfBoundsException("index " + index + " >= " + selectItemList.size());
        }
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, (UIOutput)uiSelectOne);
        }
        catch (FacesException e) {
            converter = null;
        }
        Object currentValue = uiSelectOne.getValue();
        SelectItem selectItem = (SelectItem)selectItemList.get(index);
        Object itemValue = selectItem.getValue();
        String itemStrValue = converter == null ? itemValue.toString() : converter.getAsString(facesContext, (UIComponent)uiSelectOne, itemValue);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("label", (UIComponent)uiSelectOne);
        this.renderRadio(facesContext, (UIInput)uiSelectOne, itemStrValue, selectItem.getLabel(), currentValue == null && itemValue == null || currentValue != null && currentValue.equals(itemValue), false);
        writer.endElement("label");
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return false;
        }
        return super.isDisabled(facesContext, uiComponent);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        if (!(uiComponent instanceof HtmlRadio)) {
            super.decode(facesContext, uiComponent);
        }
    }
}

