/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.AbstractCriterion;
import net.sf.hibernate.expression.Criterion;

public abstract class LogicalExpression
extends AbstractCriterion {
    private Criterion lhs;
    private Criterion rhs;

    LogicalExpression(Criterion lhs, Criterion rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass, Map aliasClasses) throws HibernateException {
        TypedValue[] lhstv = this.lhs.getTypedValues(sessionFactory, persistentClass, aliasClasses);
        TypedValue[] rhstv = this.rhs.getTypedValues(sessionFactory, persistentClass, aliasClasses);
        TypedValue[] result = new TypedValue[lhstv.length + rhstv.length];
        System.arraycopy(lhstv, 0, result, 0, lhstv.length);
        System.arraycopy(rhstv, 0, result, lhstv.length, rhstv.length);
        return result;
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias, Map aliasClasses) throws HibernateException {
        return '(' + this.lhs.toSqlString(sessionFactory, persistentClass, alias, aliasClasses) + ' ' + this.getOp() + ' ' + this.rhs.toSqlString(sessionFactory, persistentClass, alias, aliasClasses) + ')';
    }

    abstract String getOp();

    public String toString() {
        return this.lhs.toString() + ' ' + this.getOp() + ' ' + this.rhs.toString();
    }
}

