/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.seasar.framework.log.Logger;

public class MessageUtil {
    private static final String DETAIL_SUFFIX = "_detail";
    private static Logger logger_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.jsf.util.MessageUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    private MessageUtil() {
    }

    public static FacesMessage getErrorMessage(String messageId, Object[] args) {
        return MessageUtil.getMessage(messageId, args, FacesMessage.SEVERITY_ERROR);
    }

    public static FacesMessage getMessage(String messageId, Object[] args, FacesMessage.Severity severity) {
        return MessageUtil.getMessage(messageId, args, FacesMessage.SEVERITY_ERROR, FacesContext.getCurrentInstance());
    }

    public static FacesMessage getMessage(String messageId, Object[] args, FacesMessage.Severity severity, FacesContext context) {
        return MessageUtil.getMessage(messageId, args, severity, context.getApplication().getMessageBundle(), context.getViewRoot().getLocale());
    }

    public static FacesMessage getMessage(String messageId, Object[] args, FacesMessage.Severity severity, String appBundleName, Locale locale) {
        MessageFormat format;
        ResourceBundle appBundle = null;
        ResourceBundle defBundle = null;
        String summary = null;
        String detail = null;
        appBundle = MessageUtil.getBundle(appBundleName, locale);
        summary = MessageUtil.getBundleString(appBundle, messageId);
        if (summary != null) {
            detail = MessageUtil.getBundleString(appBundle, String.valueOf(messageId) + DETAIL_SUFFIX);
        } else {
            defBundle = MessageUtil.getBundle("javax.faces.Messages", locale);
            summary = MessageUtil.getBundleString(defBundle, messageId);
            if (summary != null) {
                detail = MessageUtil.getBundleString(defBundle, String.valueOf(messageId) + DETAIL_SUFFIX);
            } else {
                detail = MessageUtil.getBundleString(appBundle, String.valueOf(messageId) + DETAIL_SUFFIX);
                if (detail != null) {
                    summary = null;
                } else {
                    detail = MessageUtil.getBundleString(defBundle, String.valueOf(messageId) + DETAIL_SUFFIX);
                    if (detail != null) {
                        summary = null;
                    } else {
                        return null;
                    }
                }
            }
        }
        if (summary != null) {
            format = new MessageFormat(summary, locale);
            summary = format.format(args);
        }
        if (detail != null) {
            format = new MessageFormat(detail, locale);
            detail = format.format(args);
        }
        return new FacesMessage(severity, summary, detail);
    }

    public static String getBundleString(ResourceBundle bundle, String key) {
        try {
            return bundle == null ? null : bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static ResourceBundle getBundle(String bundleName, Locale locale) {
        if (bundleName == null) {
            return null;
        }
        try {
            return ResourceBundle.getBundle(bundleName, locale, Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException ex) {
            logger_.log((Throwable)ex);
            return null;
        }
    }
}

