/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.NoArgSQLFunction;
import net.sf.hibernate.dialect.StandardSQLFunction;
import net.sf.hibernate.exception.ErrorCodeConverter;
import net.sf.hibernate.exception.SQLExceptionConverter;
import net.sf.hibernate.exception.ViolatedConstraintNameExtracter;
import net.sf.hibernate.sql.CaseFragment;
import net.sf.hibernate.sql.HSQLCaseFragment;

public class HSQLDialect
extends Dialect {
    public HSQLDialect() {
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(-2, "binary");
        this.registerColumnType(-7, "bit");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "decimal");
        this.registerColumnType(8, "double");
        this.registerColumnType(6, "float");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-4, "longvarbinary");
        this.registerColumnType(-1, "longvarchar");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2, "numeric");
        this.registerColumnType(2004, "longvarbinary");
        this.registerColumnType(2005, "longvarchar");
        this.registerFunction("ascii", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("char", new StandardSQLFunction(Hibernate.CHARACTER));
        this.registerFunction("length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("lower", new StandardSQLFunction());
        this.registerFunction("upper", new StandardSQLFunction());
        this.registerFunction("lcase", new StandardSQLFunction());
        this.registerFunction("ucase", new StandardSQLFunction());
        this.registerFunction("soundex", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("ltrim", new StandardSQLFunction());
        this.registerFunction("rtrim", new StandardSQLFunction());
        this.registerFunction("reverse", new StandardSQLFunction());
        this.registerFunction("space", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("rawtohex", new StandardSQLFunction());
        this.registerFunction("hextoraw", new StandardSQLFunction());
        this.registerFunction("user", new NoArgSQLFunction(Hibernate.STRING));
        this.registerFunction("database", new NoArgSQLFunction(Hibernate.STRING));
        this.registerFunction("curdate", new NoArgSQLFunction(Hibernate.DATE));
        this.registerFunction("now", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("curtime", new NoArgSQLFunction(Hibernate.TIME));
        this.registerFunction("day", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayofweek", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayofyear", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayofmonth", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("month", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("year", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("week", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("quater", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("hour", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("minute", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("second", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayname", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("monthname", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("abs", new StandardSQLFunction());
        this.registerFunction("sign", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log10", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("pi", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("rand", new StandardSQLFunction(Hibernate.FLOAT));
        this.registerFunction("radians", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("roundmagic", new StandardSQLFunction());
        this.registerFunction("ceiling", new StandardSQLFunction());
        this.registerFunction("floor", new StandardSQLFunction());
        this.registerFunction("mod", new StandardSQLFunction(Hibernate.INTEGER));
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentityColumnString() {
        return "generated by default as identity (start with 1)";
    }

    public String getIdentitySelectString() {
        return "call identity()";
    }

    public String getIdentityInsertString() {
        return "null";
    }

    public boolean supportsForUpdate() {
        return false;
    }

    public boolean supportsUnique() {
        return false;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuffer(sql.length() + 10).append(sql).insert(6, hasOffset ? " limit ? ?" : " top ?").toString();
    }

    public CaseFragment createCaseFragment() {
        return new HSQLCaseFragment();
    }

    public boolean bindLimitParametersFirst() {
        return true;
    }

    public boolean supportsIfExistsAfterTableName() {
        return true;
    }

    public boolean supportsCheck() {
        return false;
    }

    public SQLExceptionConverter buildSQLExceptionConverter() {
        return new ExceptionConverter(this.getViolatedConstraintNameExtracter());
    }

    private static class ExceptionConverter
    extends ErrorCodeConverter {
        private int[] sqlGrammarCodes = new int[]{-22, -28};
        private int[] integrityViolationCodes = new int[]{-9, -177};

        public ExceptionConverter(ViolatedConstraintNameExtracter extracter) {
            super(extracter);
        }

        protected int[] getSQLGrammarErrorCodes() {
            return this.sqlGrammarCodes;
        }

        protected int[] getIntegrityViolationErrorCodes() {
            return this.integrityViolationCodes;
        }
    }
}

