/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.jca;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import net.sf.hibernate.Databinder;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.exception.SQLExceptionConverter;
import net.sf.hibernate.jca.ManagedConnectionFactoryImpl;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.metadata.CollectionMetadata;

public final class JCASessionFactoryImpl
implements SessionFactory,
Referenceable {
    private final ManagedConnectionFactoryImpl managedFactory;
    private final ConnectionManager cxManager;
    private Reference reference;

    public JCASessionFactoryImpl(ManagedConnectionFactoryImpl managedFactory, ConnectionManager cxManager) throws HibernateException {
        this.managedFactory = managedFactory;
        this.cxManager = cxManager;
    }

    public void close() throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public Map getAllClassMetadata() throws HibernateException {
        return this.getSessionFactory().getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return this.getSessionFactory().getAllCollectionMetadata();
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getSessionFactory().getClassMetadata(persistentClass);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return this.getSessionFactory().getCollectionMetadata(roleName);
    }

    public Databinder openDatabinder() throws HibernateException {
        return this.getSessionFactory().openDatabinder();
    }

    public Session openSession() throws HibernateException {
        Session result = null;
        try {
            result = (Session)this.cxManager.allocateConnection((ManagedConnectionFactory)this.managedFactory, null);
        }
        catch (ResourceException re) {
            throw new HibernateException(re);
        }
        return result;
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.getSessionFactory().openSession(connection, interceptor);
    }

    public Session openSession(Connection connection) {
        return this.getSessionFactory().openSession(connection);
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        return this.getSessionFactory().openSession(interceptor);
    }

    public Reference getReference() throws NamingException {
        return this.reference;
    }

    public void setReference(Reference ref) {
        this.reference = ref;
    }

    private SessionFactory getSessionFactory() {
        return this.managedFactory.getSessionFactory();
    }

    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.getSessionFactory().evict(persistentClass, id);
    }

    public void evict(Class persistentClass) throws HibernateException {
        this.getSessionFactory().evict(persistentClass);
    }

    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.getSessionFactory().evictCollection(roleName, id);
    }

    public void evictCollection(String roleName) throws HibernateException {
        this.getSessionFactory().evictCollection(roleName);
    }

    public void evictQueries() throws HibernateException {
        this.getSessionFactory().evictQueries();
    }

    public void evictQueries(String cacheRegion) throws HibernateException {
        this.getSessionFactory().evictQueries(cacheRegion);
    }

    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.getSessionFactory().getSQLExceptionConverter();
    }
}

