package test.org.seasar.hibernate.dao.impl;

import java.math.BigDecimal;
import java.util.List;

import org.seasar.extension.unit.S2TestCase;

import examples.hibernate.dao.EmployeeAutoDao;
import examples.hibernate.dto.EmployeeSearchDto;

public class EmployeeDaoSearchDtoTest extends S2TestCase {

	private EmployeeAutoDao dao_;
	/**
	 * Constructor for S2SessionFactoryImplTest.
	 * @param arg0
	 */
	public EmployeeDaoSearchDtoTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(EmployeeDaoSearchDtoTest.class);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		include("examples/hibernate/client/EmployeeAutoDao.dicon");
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}


	public void testGetEmployeeByGtLtSalDto(){
		EmployeeSearchDto dto1 = new EmployeeSearchDto();
		
		dto1.setFromSal(new BigDecimal(1000));
		dto1.setToSal(new BigDecimal(2000));
		
		List ret = dao_.getEmployeeByDto( dto1 );

		assertEquals(6,ret.size() );
	}

	public void testGetEmployeeByGtLtSalDto2(){

		EmployeeSearchDto dto2 = new EmployeeSearchDto();
		dto2.setFromSal(new BigDecimal(1000));

		List ret2 = dao_.getEmployeeByDto( dto2 );
		
		assertEquals(11,ret2.size() );
	}
	public void testGetEmployeeByGtLtSalDto3(){

		EmployeeSearchDto dto3 = new EmployeeSearchDto();
		dto3.setToSal(new BigDecimal(2000));
		
		List ret3 = dao_.getEmployeeByDto( dto3);
		
		assertEquals(8,ret3.size() );

	}

	
	
}