package test.org.seasar.hibernate.impl;

import java.util.List;

import net.sf.hibernate.Criteria;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.expression.Example;

import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.hibernate.S2Session;
import org.seasar.hibernate.impl.S2SessionFactoryImpl;

import examples.hibernate.entity.Employee;

public class S2SessionFactoryImpl2Test extends S2TestCase {

	private static final String CONFIG_PATH =
		"test/org/seasar/hibernate/impl/hibernate.cfg.xml";
	private S2SessionFactoryImpl s2SessionFactory_;
	
	/**
	 * Constructor for S2SessionFactoryImplTest.
	 * @param arg0
	 */
	public S2SessionFactoryImpl2Test(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(S2SessionFactoryImpl2Test.class);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		include("j2ee.dicon");
		ComponentDef cd = new ComponentDefImpl(S2SessionFactoryImpl.class, "s2SessionFactory");
		cd.addPropertyDef(new PropertyDefImpl("configPath", CONFIG_PATH));
		register(cd);
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetSessionFactory() {
		assertNotNull("1", s2SessionFactory_.getSessionFactory());
	}
	
	public void testGetSessionTx() throws Exception {
		S2Session session = s2SessionFactory_.getSession();
		Emp emp = new Emp();
		emp.setEmpno( 7900);
		emp.setEname("test");
		emp.setDeptno((short)10);
					
		session.save( emp ) ;
		session.flush();
		session.close();
		
	}
	
	public void testGetSession2Tx() throws Exception {
//		S2Session session = s2SessionFactory_.getSession();
//		Emp emp = new Emp();
//		emp.setEmpno( 7900);
//		emp.setEname("test");
//		emp.setDeptno((short)10);
//					
//		session.save( emp ) ;
//		session.flush();
//		session.close();
		int empno = 7900;
		
		Employee employee = new Employee();
		employee.setEmpno(new Integer(empno));
		Example example = Example.create(employee);
	
		S2Session session = s2SessionFactory_.getSession();
		Criteria criteria = session.createCriteria(Employee.class);
		criteria.add(example);
		List result = criteria.list();
		   
		List results = session.createCriteria(Employee.class)
		    .add( Example.create(employee) )
		    .list();
	   
	   assertEquals( 1,result.size());
	   
//		   if (result.size() > 0) {
//		    return (Employee) result.get(0);
//		   } else {
//		    return null;
//		   }


		
	}

}