/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.remoting.common.connector.impl;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.remoting.common.connector.impl.URLBasedConnector;

public abstract class TargetSpecificURLBasedConnector
extends URLBasedConnector {
    protected static final int DEFAULT_MAX_CACHED_URLS = 10;
    protected LRUMap cachedURLs = new LRUMap(10);

    public synchronized void setMaxCachedURLs(int maxCachedURLs) {
        this.cachedURLs.setMaxSize(maxCachedURLs);
    }

    public Object invoke(String remoteName, Method method, Object[] args) throws Throwable {
        return this.invoke(this.getTargetURL(remoteName), method, args);
    }

    protected synchronized URL getTargetURL(String remoteName) throws MalformedURLException {
        URL targetURL = (URL)this.cachedURLs.get(remoteName);
        if (targetURL == null) {
            targetURL = new URL(this.baseURL, remoteName);
            this.cachedURLs.put(remoteName, targetURL);
        }
        return targetURL;
    }

    protected abstract Object invoke(URL var1, Method var2, Object[] var3) throws Throwable;

    protected static class LRUMap
    extends LinkedHashMap {
        protected static final int DEFAULT_INITIAL_CAPACITY = 16;
        protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
        protected int maxSize;

        public LRUMap(int maxSize) {
            this(maxSize, 16, 0.75f);
        }

        public LRUMap(int maxSize, int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, true);
            this.maxSize = maxSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.maxSize > 0 && this.size() > this.maxSize;
        }
    }
}

