/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.remoting.common.interceptor;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.remoting.common.connector.Connector;

public class RemotingInterceptor
extends AbstractInterceptor {
    protected Connector connector;
    protected String remoteName;

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setRemoteName(String remoteName) {
        this.remoteName = remoteName;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (MethodUtil.isAbstract((Method)method)) {
            return this.connector.invoke(this.getRemoteName(invocation), method, invocation.getArguments());
        }
        return invocation.proceed();
    }

    protected String getRemoteName(MethodInvocation invocation) {
        if (this.remoteName != null) {
            return this.remoteName;
        }
        ComponentDef componentDef = this.getComponentDef(invocation);
        String componentName = componentDef.getComponentName();
        if (componentName != null) {
            return componentName;
        }
        Class componentClass = componentDef.getComponentClass();
        if (componentClass != null) {
            return ClassUtil.getShortClassName((Class)componentClass);
        }
        return ClassUtil.getShortClassName(invocation.getThis().getClass());
    }
}

