/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import org.jboss.cache.Fqn;

public class TreeCache
implements Cache {
    private static final String ITEM = "item";
    private org.jboss.cache.TreeCache cache;
    private final String regionName;
    static /* synthetic */ Class class$net$sf$hibernate$cache$TreeCache;

    public TreeCache(org.jboss.cache.TreeCache cache, String regionName) {
        this.cache = cache;
        this.regionName = '/' + regionName.replace('.', '/');
    }

    public Object get(Object key) throws CacheException {
        try {
            return this.cache.get(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void put(Object key, Object value) throws CacheException {
        try {
            this.cache.put(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM, value);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void remove(Object key) throws CacheException {
        try {
            this.cache.remove(new Fqn(new Object[]{this.regionName, key}));
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void clear() throws CacheException {
        try {
            this.cache.remove(new Fqn((Object)this.regionName));
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws CacheException {
        Class clazz = class$net$sf$hibernate$cache$TreeCache == null ? (class$net$sf$hibernate$cache$TreeCache = TreeCache.class$("net.sf.hibernate.cache.TreeCache")) : class$net$sf$hibernate$cache$TreeCache;
        synchronized (clazz) {
            if (this.cache != null) {
                this.cache.stop();
                this.cache.destroy();
                this.cache = null;
            }
        }
    }

    public void lock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache" + this.regionName);
    }

    public void unlock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

