/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.AbstractCriterion;
import net.sf.hibernate.util.StringHelper;

public class NotNullExpression
extends AbstractCriterion {
    private final String propertyName;
    private static final TypedValue[] NO_VALUES = new TypedValue[0];

    NotNullExpression(String propertyName) {
        this.propertyName = propertyName;
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias, Map aliasClasses) throws HibernateException {
        String[] columns = NotNullExpression.getColumns(sessionFactory, persistentClass, this.propertyName, alias, aliasClasses);
        String result = StringHelper.join(" or ", StringHelper.suffix(columns, " is not null"));
        if (columns.length > 1) {
            result = "(" + result + ")";
        }
        return result;
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass, Map aliasClasses) throws HibernateException {
        return NO_VALUES;
    }

    public String toString() {
        return this.propertyName + " is not null";
    }
}

