/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.QueryableCollection;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.loader.Loader;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.persister.Joinable;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.persister.OuterJoinLoadable;
import net.sf.hibernate.sql.ConditionFragment;
import net.sf.hibernate.sql.DisjunctionFragment;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.OneToOneType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.StringHelper;

public abstract class OuterJoinLoader
extends Loader {
    public static final int EAGER = 1;
    public static final int AUTO = 0;
    public static final int LAZY = -1;
    protected Loadable[] classPersisters;
    protected LockMode[] lockModeArray;
    protected int[] owners;
    protected String sql;
    protected String[] suffixes;
    private Dialect dialect;

    public OuterJoinLoader(Dialect dialect) {
        this.dialect = dialect;
    }

    protected boolean isJoinedFetchEnabled(Type type, boolean mappingDefault, String path, String table, String[] foreignKeyColumns) {
        return type.isEntityType() && mappingDefault;
    }

    protected int getJoinType(AssociationType type, int config, String path, String table, String[] foreignKeyColumns, SessionFactoryImplementor factory) throws MappingException {
        boolean mappingDefault = this.isJoinedFetchEnabledByDefault(config, type, factory);
        return this.isJoinedFetchEnabled(type, mappingDefault, path, table, foreignKeyColumns) ? 1 : -1;
    }

    protected final List walkTree(OuterJoinLoadable persister, String alias, SessionFactoryImplementor factory) throws MappingException {
        ArrayList associations = new ArrayList();
        this.walkClassTree(persister, alias, associations, new HashSet(), "", 0, factory);
        return associations;
    }

    protected final List walkCollectionTree(QueryableCollection persister, String alias, SessionFactoryImplementor factory) throws MappingException {
        return this.walkCollectionTree(persister, alias, new ArrayList(), new HashSet(), "", 0, factory);
    }

    private final List walkCollectionTree(QueryableCollection persister, String alias, List associations, Set visitedPersisters, String path, int currentDepth, SessionFactoryImplementor factory) throws MappingException {
        if (persister.isOneToMany()) {
            this.walkClassTree((OuterJoinLoadable)persister.getElementPersister(), alias, associations, visitedPersisters, path, currentDepth, factory);
        } else {
            Type type = persister.getElementType();
            if (type.isAssociationType()) {
                AssociationType etype = (AssociationType)type;
                int joinType = this.getJoinType(etype, persister.enableJoinedFetch(), path, persister.getTableName(), persister.getElementColumnNames(), factory);
                if (joinType >= 0) {
                    String[] columns = StringHelper.qualify(alias, persister.getElementColumnNames());
                    this.walkAssociationTree(etype, columns, persister, alias, associations, visitedPersisters, path, currentDepth, joinType, factory);
                }
            } else if (type.isComponentType()) {
                this.walkCompositeElementTree((AbstractComponentType)type, persister.getElementColumnNames(), persister, alias, associations, new HashSet(), path, currentDepth, factory);
            }
        }
        return associations;
    }

    private boolean isJoinedFetchAlwaysDisabled(OuterJoinLoadable persister, AssociationType etype, int propertyNumber) {
        return etype.isEntityType() && ((EntityType)etype).isOneToOne() && persister.isDefinedOnSubclass(propertyNumber);
    }

    private final void walkAssociationTree(AssociationType associationType, OuterJoinLoadable persister, int propertyNumber, String alias, List associations, Set visitedPersisters, String path, int currentDepth, SessionFactoryImplementor factory) throws MappingException {
        String[] aliasedForeignKeyColumns = OuterJoinLoader.getAliasedForeignKeyColumns(persister, alias, associationType, persister.toColumns(alias, propertyNumber));
        String[] foreignKeyColumns = OuterJoinLoader.getForeignKeyColumns(persister, associationType, persister.getSubclassPropertyColumnNames(propertyNumber));
        if (this.isJoinedFetchAlwaysDisabled(persister, associationType, propertyNumber)) {
            return;
        }
        String subpath = OuterJoinLoader.subPath(path, persister.getSubclassPropertyName(propertyNumber));
        int joinType = this.getJoinType(associationType, persister.enableJoinedFetch(propertyNumber), subpath, persister.getSubclassPropertyTableName(propertyNumber), foreignKeyColumns, factory);
        if (joinType >= 0) {
            this.walkAssociationTree(associationType, aliasedForeignKeyColumns, persister, alias, associations, visitedPersisters, subpath, currentDepth, joinType, factory);
        }
    }

    private final void walkClassTree(OuterJoinLoadable persister, String alias, List associations, Set visitedPersisters, String path, int currentDepth, SessionFactoryImplementor factory) throws MappingException {
        int n = persister.countSubclassProperties();
        for (int i = 0; i < n; ++i) {
            Type type = persister.getSubclassPropertyType(i);
            if (type.isAssociationType()) {
                this.walkAssociationTree((AssociationType)type, persister, i, alias, associations, visitedPersisters, path, currentDepth, factory);
                continue;
            }
            if (!type.isComponentType()) continue;
            this.walkComponentTree((AbstractComponentType)type, i, persister.getSubclassPropertyColumnNames(i), persister.toColumns(alias, i), persister, alias, associations, visitedPersisters, OuterJoinLoader.subPath(path, persister.getSubclassPropertyName(i)), currentDepth, factory);
        }
    }

    private void walkComponentTree(AbstractComponentType componentType, int propertyNumber, String[] cols, String[] aliasedCols, OuterJoinLoadable persister, String alias, List associations, Set visitedPersisters, String path, int currentDepth, SessionFactoryImplementor factory) throws MappingException {
        Type[] types = componentType.getSubtypes();
        String[] propertyNames = componentType.getPropertyNames();
        int begin = 0;
        for (int i = 0; i < types.length; ++i) {
            int length = types[i].getColumnSpan(factory);
            String[] range = ArrayHelper.slice(cols, begin, length);
            String[] aliasedRange = ArrayHelper.slice(aliasedCols, begin, length);
            if (types[i].isAssociationType()) {
                AssociationType associationType = (AssociationType)types[i];
                if (this.isJoinedFetchAlwaysDisabled(persister, associationType, propertyNumber)) {
                    return;
                }
                String[] aliasedFkColumns = OuterJoinLoader.getAliasedForeignKeyColumns(persister, alias, associationType, aliasedRange);
                String[] fkColumns = OuterJoinLoader.getForeignKeyColumns(persister, associationType, range);
                String subpath = OuterJoinLoader.subPath(path, propertyNames[i]);
                int joinType = this.getJoinType(associationType, componentType.enableJoinedFetch(i), subpath, persister.getSubclassPropertyTableName(propertyNumber), fkColumns, factory);
                if (joinType >= 0) {
                    this.walkAssociationTree(associationType, aliasedFkColumns, persister, alias, associations, visitedPersisters, subpath, currentDepth, joinType, factory);
                }
            } else if (types[i].isComponentType()) {
                String subpath = OuterJoinLoader.subPath(path, propertyNames[i]);
                this.walkComponentTree((AbstractComponentType)types[i], propertyNumber, range, aliasedRange, persister, alias, associations, visitedPersisters, subpath, currentDepth, factory);
            }
            begin += length;
        }
    }

    private void walkCompositeElementTree(AbstractComponentType compositeType, String[] cols, QueryableCollection persister, String alias, List associations, Set visitedPersisters, String path, int currentDepth, SessionFactoryImplementor factory) throws MappingException {
        Type[] types = compositeType.getSubtypes();
        String[] propertyNames = compositeType.getPropertyNames();
        int begin = 0;
        for (int i = 0; i < types.length; ++i) {
            int length = types[i].getColumnSpan(factory);
            String[] range = ArrayHelper.slice(cols, begin, length);
            if (types[i].isAssociationType()) {
                AssociationType associationType = (AssociationType)types[i];
                String[] aliasedForeignKeyColumns = StringHelper.qualify(alias, range);
                String subpath = OuterJoinLoader.subPath(path, propertyNames[i]);
                int joinType = this.getJoinType(associationType, compositeType.enableJoinedFetch(i), subpath, persister.getTableName(), range, factory);
                if (joinType >= 0) {
                    this.walkAssociationTree(associationType, aliasedForeignKeyColumns, persister, alias, associations, visitedPersisters, subpath, currentDepth, joinType, factory);
                }
            } else if (types[i].isComponentType()) {
                String subpath = OuterJoinLoader.subPath(path, propertyNames[i]);
                this.walkCompositeElementTree((AbstractComponentType)types[i], range, persister, alias, associations, visitedPersisters, subpath, currentDepth, factory);
            }
            begin += length;
        }
    }

    protected boolean isJoinedFetchEnabledByDefault(int config, AssociationType type, SessionFactoryImplementor factory) throws MappingException {
        if (!type.isEntityType() && !type.isPersistentCollectionType()) {
            return false;
        }
        if (config == 1) {
            return true;
        }
        if (config == -1) {
            return false;
        }
        if (!factory.isOuterJoinedFetchEnabled()) {
            return false;
        }
        if (type.isEntityType()) {
            EntityType entityType = (EntityType)type;
            ClassPersister persister = factory.getPersister(entityType.getAssociatedClass());
            return !persister.hasProxy() || entityType.isOneToOne() && ((OneToOneType)entityType).isNullable();
        }
        return false;
    }

    private void walkAssociationTree(AssociationType type, String[] aliasedForeignKeyColumns, Joinable persister, String alias, List associations, Set visitedPersisters, String path, int currentDepth, int joinType, SessionFactoryImplementor factory) throws MappingException {
        boolean enable;
        Joinable joinable = type.getJoinable(factory);
        Integer maxFetchDepth = factory.getMaximumFetchDepth();
        boolean bl = enable = joinType == 0 || (maxFetchDepth == null || currentDepth < maxFetchDepth) && !visitedPersisters.contains(joinable) && (!joinable.isCollection() || !OuterJoinLoader.containsCollectionPersister(associations));
        if (enable) {
            visitedPersisters.add(persister);
            OuterJoinableAssociation assoc = new OuterJoinableAssociation();
            associations.add(assoc);
            String subalias = this.generateTableAlias(joinable.getName(), associations.size(), path, joinable.isManyToMany());
            assoc.joinable = joinable;
            assoc.tableName = joinable.getTableName();
            assoc.primaryKeyColumns = type.getReferencedColumns(factory);
            assoc.foreignKeyColumns = aliasedForeignKeyColumns;
            assoc.subalias = subalias;
            assoc.owner = OuterJoinLoader.getPosition(alias, associations);
            assoc.isOneToOne = type.isEntityType() && ((EntityType)type).isOneToOne() && !((EntityType)type).isUniqueKeyReference();
            assoc.joinType = joinType;
            if (assoc.foreignKeyColumns.length != assoc.primaryKeyColumns.length || assoc.foreignKeyColumns.length == 0) {
                throw new MappingException("invalid join columns for association: " + path);
            }
            int nextDepth = currentDepth + 1;
            if (!joinable.isCollection()) {
                if (joinable instanceof OuterJoinLoadable) {
                    this.walkClassTree((OuterJoinLoadable)joinable, subalias, associations, visitedPersisters, path, nextDepth, factory);
                }
            } else if (joinable instanceof QueryableCollection) {
                this.walkCollectionTree((QueryableCollection)joinable, subalias, associations, visitedPersisters, path, nextDepth, factory);
            }
        }
    }

    protected final String getSQLString() {
        return this.sql;
    }

    protected final Loadable[] getPersisters() {
        return this.classPersisters;
    }

    protected final String selectString(List associations, SessionFactoryImplementor factory) throws MappingException {
        if (associations.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(associations.size() * 100).append(", ");
        int aliasCount = 0;
        for (int i = 0; i < associations.size(); ++i) {
            OuterJoinableAssociation join = (OuterJoinableAssociation)associations.get(i);
            String selectFragment = join.joinable.selectFragment(join.subalias, this.getSuffixes()[aliasCount], join.joinType == 1);
            buf.append(selectFragment);
            if (join.joinable.consumesAlias()) {
                ++aliasCount;
            }
            if (i >= associations.size() - 1 || selectFragment.trim().equals("")) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    protected String[] getSuffixes() {
        return this.suffixes;
    }

    protected String generateTableAlias(String className, int n, String path, boolean isLinkTable) {
        return OuterJoinLoader.generateAlias(className, n);
    }

    protected String generateRootAlias(String tableName) {
        return OuterJoinLoader.generateAlias(tableName, 0);
    }

    protected CollectionPersister getCollectionPersister() {
        return null;
    }

    protected final JoinFragment mergeOuterJoins(List associations) {
        JoinFragment outerjoin = this.dialect.createOuterJoinFragment();
        Iterator iter = associations.iterator();
        while (iter.hasNext()) {
            OuterJoinableAssociation oj = (OuterJoinableAssociation)iter.next();
            outerjoin.addJoin(oj.tableName, oj.subalias, oj.foreignKeyColumns, oj.primaryKeyColumns, oj.joinType);
            outerjoin.addJoins(oj.joinable.fromJoinFragment(oj.subalias, false, true), oj.joinable.whereJoinFragment(oj.subalias, false, true));
        }
        return outerjoin;
    }

    protected static final int countClassPersisters(List associations) {
        int result = 0;
        Iterator iter = associations.iterator();
        while (iter.hasNext()) {
            OuterJoinableAssociation oj = (OuterJoinableAssociation)iter.next();
            if (!oj.joinable.consumesAlias()) continue;
            ++result;
        }
        return result;
    }

    protected static boolean containsCollectionPersister(List associations) {
        Iterator iter = associations.iterator();
        while (iter.hasNext()) {
            OuterJoinableAssociation oj = (OuterJoinableAssociation)iter.next();
            if (!oj.joinable.isCollection()) continue;
            return true;
        }
        return false;
    }

    protected LockMode[] getLockModes(Map lockModes) {
        return this.lockModeArray;
    }

    protected LockMode[] createLockModeArray(int length, LockMode lockMode) {
        Object[] array = new LockMode[length];
        Arrays.fill(array, lockMode);
        return array;
    }

    private static String subPath(String path, String property) {
        if (path == null || path.length() == 0) {
            return property;
        }
        return StringHelper.qualify(path, property);
    }

    protected static StringBuffer whereString(String alias, String[] columnNames, int batchSize) {
        ConditionFragment byId = new ConditionFragment().setTableAlias(alias).setCondition(columnNames, "?");
        StringBuffer whereString = new StringBuffer();
        if (batchSize == 1) {
            whereString.append(byId.toFragmentString());
        } else {
            whereString.append("(");
            DisjunctionFragment df = new DisjunctionFragment();
            for (int i = 0; i < batchSize; ++i) {
                df.addCondition(byId);
            }
            whereString.append(df.toFragmentString());
            whereString.append(")");
        }
        return whereString;
    }

    private static int getPosition(String alias, List associations) {
        int result = 0;
        for (int i = 0; i < associations.size(); ++i) {
            OuterJoinableAssociation oj = (OuterJoinableAssociation)associations.get(i);
            if (!oj.joinable.consumesAlias()) continue;
            if (oj.subalias.equals(alias)) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    private static String[] getAliasedForeignKeyColumns(OuterJoinLoadable persister, String alias, AssociationType associationType, String[] aliasedPropertyColumns) {
        if (associationType.usePrimaryKeyAsForeignKey()) {
            return StringHelper.qualify(alias, persister.getIdentifierColumnNames());
        }
        return aliasedPropertyColumns;
    }

    private static String[] getForeignKeyColumns(OuterJoinLoadable persister, AssociationType associationType, String[] propertyColumns) {
        if (associationType.usePrimaryKeyAsForeignKey()) {
            return persister.getIdentifierColumnNames();
        }
        return propertyColumns;
    }

    protected int[] getOwners() {
        return this.owners;
    }

    protected int toOwner(OuterJoinableAssociation oj, int joins, boolean dontIgnore) {
        if (dontIgnore) {
            return oj.owner == -1 ? joins : oj.owner;
        }
        return -1;
    }

    public static final class OuterJoinableAssociation {
        Joinable joinable;
        String[] foreignKeyColumns;
        String subalias;
        String[] primaryKeyColumns;
        String tableName;
        int owner;
        int joinType;
        boolean isOneToOne;
    }
}

