/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.persister;

import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.persister.PropertyMapping;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.StringHelper;

public abstract class AbstractPropertyMapping
implements PropertyMapping {
    private final Map typesByPropertyPath = new HashMap();
    private final Map columnsByPropertyPath = new HashMap();
    private final Map formulaTemplatesByPropertyPath = new HashMap();

    public String[] getIdentifierColumnNames() {
        throw new UnsupportedOperationException("one-to-one is not supported here");
    }

    protected abstract String getClassName();

    public Type toType(String propertyName) throws QueryException {
        Type type = (Type)this.typesByPropertyPath.get(propertyName);
        if (type == null) {
            throw new QueryException("could not resolve property: " + propertyName + " of: " + this.getClassName());
        }
        return type;
    }

    public String[] toColumns(String alias, String propertyName) throws QueryException {
        String[] columns = (String[])this.columnsByPropertyPath.get(propertyName);
        if (columns == null) {
            String template = (String)this.formulaTemplatesByPropertyPath.get(propertyName);
            if (template == null) {
                throw new QueryException("could not resolve property: " + propertyName + " of: " + this.getClassName());
            }
            return new String[]{StringHelper.replace(template, "$PlaceHolder$", alias)};
        }
        return StringHelper.qualify(alias, columns);
    }

    protected void addPropertyPath(String path, Type type, String[] columns) {
        this.typesByPropertyPath.put(path, type);
        this.columnsByPropertyPath.put(path, columns);
        this.handlePath(path, type);
    }

    protected void addFormulaPropertyPath(String path, Type type, String template) {
        this.typesByPropertyPath.put(path, type);
        this.formulaTemplatesByPropertyPath.put(path, template);
        this.handlePath(path, type);
    }

    protected void initPropertyPaths(String path, Type type, String[] columns, String formulaTemplate, SessionFactoryImplementor factory) throws MappingException {
        if (formulaTemplate != null) {
            this.addFormulaPropertyPath(path, type, formulaTemplate);
        } else {
            this.initPropertyPaths(path, type, columns, factory);
        }
    }

    protected void initPropertyPaths(String path, Type type, String[] columns, SessionFactoryImplementor factory) throws MappingException {
        if (columns.length != type.getColumnSpan(factory)) {
            throw new MappingException("broken column mapping for: " + path + " of: " + this.getClassName());
        }
        if (type.isAssociationType() && ((AssociationType)type).usePrimaryKeyAsForeignKey()) {
            columns = this.getIdentifierColumnNames();
        }
        if (path != null) {
            this.addPropertyPath(path, type, columns);
        }
        if (type.isComponentType()) {
            this.initComponentPropertyPaths(path, (AbstractComponentType)type, columns, factory);
        } else if (type.isEntityType()) {
            this.initIdentifierPropertyPaths(path, (EntityType)type, columns, factory);
        }
    }

    protected void initIdentifierPropertyPaths(String path, EntityType etype, String[] columns, SessionFactoryImplementor factory) throws MappingException {
        String idPropName;
        Type idtype = etype.getIdentifierOrUniqueKeyType(factory);
        if (!etype.isUniqueKeyReference()) {
            String idpath1 = AbstractPropertyMapping.extendPath(path, "id");
            this.addPropertyPath(idpath1, idtype, columns);
            this.initPropertyPaths(idpath1, idtype, columns, factory);
        }
        if ((idPropName = etype.getIdentifierOrUniqueKeyPropertyName(factory)) != null) {
            String idpath2 = AbstractPropertyMapping.extendPath(path, idPropName);
            this.addPropertyPath(idpath2, idtype, columns);
            this.initPropertyPaths(idpath2, idtype, columns, factory);
        }
    }

    protected void initComponentPropertyPaths(String path, AbstractComponentType type, String[] columns, SessionFactoryImplementor factory) throws MappingException {
        Type[] types = type.getSubtypes();
        String[] properties = type.getPropertyNames();
        int begin = 0;
        for (int i = 0; i < properties.length; ++i) {
            String subpath = AbstractPropertyMapping.extendPath(path, properties[i]);
            try {
                int length = types[i].getColumnSpan(factory);
                String[] columnSlice = ArrayHelper.slice(columns, begin, length);
                this.initPropertyPaths(subpath, types[i], columnSlice, factory);
                begin += length;
                continue;
            }
            catch (Exception e) {
                throw new MappingException("bug in initComponentPropertyPaths", e);
            }
        }
    }

    private static String extendPath(String path, String property) {
        if (path == null) {
            return property;
        }
        return StringHelper.qualify(path, property);
    }

    protected void handlePath(String path, Type type) {
    }
}

