/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigHelper {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$util$ConfigHelper == null ? (class$net$sf$hibernate$util$ConfigHelper = ConfigHelper.class$("net.sf.hibernate.util.ConfigHelper")) : class$net$sf$hibernate$util$ConfigHelper));
    static /* synthetic */ Class class$net$sf$hibernate$util$ConfigHelper;

    public static final URL locateConfig(String path) {
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return ConfigHelper.findAsResource(path);
        }
    }

    public static final URL findAsResource(String path) {
        URL url = null;
        url = Thread.currentThread().getContextClassLoader().getResource(path);
        if (url != null) {
            return url;
        }
        url = (class$net$sf$hibernate$util$ConfigHelper == null ? (class$net$sf$hibernate$util$ConfigHelper = ConfigHelper.class$("net.sf.hibernate.util.ConfigHelper")) : class$net$sf$hibernate$util$ConfigHelper).getClassLoader().getResource(path);
        if (url != null) {
            return url;
        }
        url = ClassLoader.getSystemClassLoader().getResource(path);
        return url;
    }

    public static final InputStream getConfigStream(String path) throws HibernateException {
        URL url = ConfigHelper.locateConfig(path);
        if (url == null) {
            String msg = "Unable to locate config file: " + path;
            log.fatal((Object)msg);
            throw new HibernateException(msg);
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new HibernateException("Unable to open config file: " + path, e);
        }
    }

    public static final Reader getConfigStreamReader(String path) throws HibernateException {
        return new InputStreamReader(ConfigHelper.getConfigStream(path));
    }

    public static final Properties getConfigProperties(String path) throws HibernateException {
        try {
            Properties properties = new Properties();
            properties.load(ConfigHelper.getConfigStream(path));
            return properties;
        }
        catch (IOException e) {
            throw new HibernateException("Unable to load properties from specified config file: " + path, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

