package org.seasar.hibernate.dao.criteria;

import net.sf.hibernate.Criteria;

/**
 * @author kenichi_okazaki
 *
 */
public class MaxResultsCriteriaCommand extends abstractCriteriaCommand {

	/**
	 * @param fieldName
	 * @param dtoFieldName
	 */
	public MaxResultsCriteriaCommand(String fieldName, String dtoFieldName) {
		super(fieldName, dtoFieldName);
	}

	/* (non-Javadoc)
	 * @see org.seasar.hibernate.dao.criteria.CriteriaCommand#getCriteria(net.sf.hibernate.Criteria, java.lang.Object)
	 */
	public Criteria getCriteria(Criteria criteria,Object value) {

		return criteria.setMaxResults( ((Integer)value).intValue() );
	}


}
