package org.seasar.hibernate.interceptor;

import net.sf.hibernate.FlushMode;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.hibernate.S2Session;
import org.seasar.hibernate.S2SessionFactory;

/**
 * @author koichik
 */
public class ReadOnlySessionInterceptor extends AbstractInterceptor {
    private S2SessionFactory sessionFactory;

    public void setSessionFactory(S2SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        S2Session session = sessionFactory.getSession();
        session.setReadOnly(true);
        session.setFlushMode(FlushMode.NEVER);

        return invocation.proceed();
    }
}