/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.servlet.jsp.jstl.sql.Result;

public class UIData
extends UIComponentBase
implements NamingContainer {
    private static final int STATE_SIZE = 6;
    private static final int SUPER_STATE_INDEX = 0;
    private static final int FIRST_INDEX = 1;
    private static final int ROWS_INDEX = 2;
    private static final int VALUE_INDEX = 3;
    private static final int VAR_INDEX = 4;
    private static final int ROW_STATE_INDEX = 5;
    private static final String FOOTER_FACET_NAME = "footer";
    private static final String HEADER_FACET_NAME = "header";
    private static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    private static final int PROCESS_DECODES = 1;
    private static final int PROCESS_VALIDATORS = 2;
    private static final int PROCESS_UPDATES = 3;
    private int _rowIndex = -1;
    private String _var = null;
    private UIDataRowState _rowState = new UIDataRowState();
    private transient boolean _saveDescendantStates = false;
    private transient boolean _firstTimeRendered = true;
    private Boolean _isEmbeddedUIData = null;
    private UIData _embeddingUIData = null;
    private DataModel _dataModel = null;
    private HashMap _dataModelMap = null;
    private static final DataModel EMPTY_DATA_MODEL = new DataModel(){

        public boolean isRowAvailable() {
            return false;
        }

        public int getRowCount() {
            return 0;
        }

        public Object getRowData() {
            throw new IllegalArgumentException();
        }

        public int getRowIndex() {
            return -1;
        }

        public void setRowIndex(int i) {
            if (i < -1) {
                throw new IllegalArgumentException();
            }
        }

        public Object getWrappedData() {
            return null;
        }

        public void setWrappedData(Object obj) {
            if (obj == null) {
                return;
            }
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }
    };
    public static final String COMPONENT_TYPE = "javax.faces.Data";
    public static final String COMPONENT_FAMILY = "javax.faces.Data";
    private static final String DEFAULT_RENDERER_TYPE = "javax.faces.Table";
    private static final int DEFAULT_FIRST = 0;
    private static final int DEFAULT_ROWS = 0;
    private Integer _first = null;
    private Integer _rows = null;
    private Object _value = null;

    public void setFooter(UIComponent footer) {
        this.getFacets().put(FOOTER_FACET_NAME, footer);
    }

    public UIComponent getFooter() {
        return (UIComponent)this.getFacets().get(FOOTER_FACET_NAME);
    }

    public void setHeader(UIComponent header) {
        this.getFacets().put(HEADER_FACET_NAME, header);
    }

    public UIComponent getHeader() {
        return (UIComponent)this.getFacets().get(HEADER_FACET_NAME);
    }

    public boolean isRowAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    public int getRowCount() {
        return this.getDataModel().getRowCount();
    }

    public Object getRowData() {
        return this.getDataModel().getRowData();
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.saveDescendantComponentStates(this.getFacesContext(), this);
        this._rowIndex = rowIndex;
        DataModel dataModel = this.getDataModel();
        dataModel.setRowIndex(rowIndex);
        String var = this.getVar();
        if (rowIndex == -1) {
            if (var != null) {
                this.getFacesContext().getExternalContext().getRequestMap().remove(var);
            }
        } else if (var != null) {
            if (this.isRowAvailable()) {
                Object rowData = dataModel.getRowData();
                this.getFacesContext().getExternalContext().getRequestMap().put(var, rowData);
            } else {
                this.getFacesContext().getExternalContext().getRequestMap().remove(var);
            }
        }
        this.restoreDescendantComponentStates(this.getFacesContext(), this, true);
    }

    private void saveDescendantComponentStates(FacesContext context, UIComponent component) {
        Iterator i = component.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent child = (UIComponent)i.next();
            if (child instanceof UIData) {
                UIData childUIData = (UIData)child;
                this._rowState._clientIdsToChildUIDataStates.put(childUIData.getClientId(context), childUIData._rowState);
                continue;
            }
            if (child instanceof EditableValueHolder) {
                EditableValueHolder childEVH = (EditableValueHolder)((Object)child);
                this._rowState._clientIdsToChildEVHStates.put(child.getClientId(context), new EditableValueHolderState(childEVH));
            }
            this.saveDescendantComponentStates(context, child);
        }
    }

    private static String getInitialClientId(FacesContext context, UIComponent component) {
        int oldRowIndex = 0;
        UIData parentUIData = null;
        UIComponent parent = component.getParent();
        while (parent != null) {
            if (parent instanceof UIData) {
                parentUIData = (UIData)parent;
                oldRowIndex = parentUIData._rowIndex;
                parentUIData._rowIndex = -1;
                break;
            }
            parent = parent.getParent();
        }
        if (parentUIData == null) {
            throw new IllegalStateException("Couldn't find a parent UIData for " + component.getClientId(context));
        }
        component.setId(component.getId());
        String clientId = component.getClientId(context);
        parentUIData._rowIndex = oldRowIndex;
        component.setId(component.getId());
        return clientId;
    }

    private void restoreDescendantComponentStates(FacesContext context, UIComponent component, boolean saveState) {
        Iterator i = component.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent child = (UIComponent)i.next();
            child.setId(child.getId());
            if (saveState) {
                Object state;
                if (child instanceof UIData) {
                    UIData childUIData = (UIData)child;
                    state = this._rowState._clientIdsToChildUIDataStates.get(childUIData.getClientId(context));
                    if (state == null) {
                        UIDataRowState initialState = (UIDataRowState)this._rowState._clientIdsToChildUIDataStates.get(UIData.getInitialClientId(context, child));
                        if (initialState == null) {
                            throw new IllegalStateException("No initial state defined for clientId: " + child.getClientId(context));
                        }
                        state = new UIDataRowState(initialState);
                    }
                    childUIData._rowState = (UIDataRowState)state;
                    this.restoreDescendantComponentStates(context, component, false);
                    continue;
                }
                if (!this._firstTimeRendered && child instanceof EditableValueHolder) {
                    EditableValueHolder childEVH = (EditableValueHolder)((Object)child);
                    state = this._rowState._clientIdsToChildEVHStates.get(child.getClientId(context));
                    if (state == null) {
                        state = this._rowState._clientIdsToChildEVHStates.get(UIData.getInitialClientId(context, child));
                    }
                    ((EditableValueHolderState)state).restore(childEVH);
                }
            }
            this.restoreDescendantComponentStates(context, child, saveState);
        }
    }

    public void setRows(int rows) {
        this._rows = new Integer(rows);
        if (rows < 0) {
            throw new IllegalArgumentException("rows: " + rows);
        }
    }

    public void setVar(String var) {
        this._var = var;
    }

    public String getVar() {
        return this._var;
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("value")) {
            this._dataModel = null;
        } else if (name.equals("var") || name.equals("rowIndex")) {
            throw new IllegalArgumentException("name " + name);
        }
        super.setValueBinding(name, binding);
    }

    public String getClientId(FacesContext context) {
        String clientId = super.getClientId(context);
        int rowIndex = this.getRowIndex();
        if (rowIndex == -1) {
            return clientId;
        }
        return clientId + "_" + rowIndex;
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent(new FacesEventWrapper(event, this.getRowIndex(), this));
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof FacesEventWrapper) {
            FacesEvent originalEvent = ((FacesEventWrapper)event).getWrappedFacesEvent();
            int eventRowIndex = ((FacesEventWrapper)event).getRowIndex();
            int currentRowIndex = this.getRowIndex();
            this.setRowIndex(eventRowIndex);
            originalEvent.getComponent().broadcast(originalEvent);
            this.setRowIndex(currentRowIndex);
        } else {
            super.broadcast(event);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (this._firstTimeRendered || this.isAllChildrenAndFacetsValid()) {
            this._saveDescendantStates = false;
            this._dataModel = null;
            if (this._dataModelMap != null) {
                this._dataModelMap.clear();
            }
        } else {
            this._saveDescendantStates = true;
        }
        super.encodeBegin(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        this.setRowIndex(-1);
        super.encodeEnd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAllChildrenAndFacetsValid() {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        int setRowIndex = this.getRowIndex();
        try {
            int rowIndex = first;
            while (true) {
                if (rowIndex >= last) {
                    break;
                }
                this.setRowIndex(rowIndex);
                if (this.isRowAvailable() && !this.isAllEditableValueHoldersValidRecursive(this.getFacetsAndChildren())) {
                    boolean bl = false;
                    Object var8_7 = null;
                    this.setRowIndex(setRowIndex);
                    return bl;
                }
                ++rowIndex;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.setRowIndex(setRowIndex);
            throw throwable;
        }
        Object var8_8 = null;
        this.setRowIndex(setRowIndex);
        return true;
    }

    private boolean isAllEditableValueHoldersValidRecursive(Iterator facetsAndChildrenIterator) {
        while (facetsAndChildrenIterator.hasNext()) {
            UIComponent c = (UIComponent)facetsAndChildrenIterator.next();
            if (c instanceof EditableValueHolder && !((EditableValueHolder)((Object)c)).isValid()) {
                return false;
            }
            if (this.isAllEditableValueHoldersValidRecursive(c.getFacetsAndChildren())) continue;
            return false;
        }
        return true;
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processFacets(context, 1);
        this.processColumnFacets(context, 1);
        this.processColumnChildren(context, 1);
        this.setRowIndex(-1);
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processFacets(context, 2);
        this.processColumnFacets(context, 2);
        this.processColumnChildren(context, 2);
        this.setRowIndex(-1);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processFacets(context, 3);
        this.processColumnFacets(context, 3);
        this.processColumnChildren(context, 3);
        this.setRowIndex(-1);
    }

    private void processFacets(FacesContext context, int processAction) {
        Iterator it = this.getFacets().values().iterator();
        while (it.hasNext()) {
            UIComponent facet = (UIComponent)it.next();
            this.process(context, facet, processAction);
        }
    }

    private void processColumnFacets(FacesContext context, int processAction) {
        Iterator childIter = this.getChildren().iterator();
        while (childIter.hasNext()) {
            UIComponent child = (UIComponent)childIter.next();
            if (!(child instanceof UIColumn) || !child.isRendered()) continue;
            Iterator facetsIter = child.getFacets().values().iterator();
            while (facetsIter.hasNext()) {
                UIComponent facet = (UIComponent)facetsIter.next();
                this.process(context, facet, processAction);
            }
        }
    }

    private void processColumnChildren(FacesContext context, int processAction) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        int rowIndex = first;
        while (rowIndex < last) {
            this.setRowIndex(rowIndex);
            if (this.isRowAvailable()) {
                Iterator it = this.getChildren().iterator();
                while (it.hasNext()) {
                    UIComponent child = (UIComponent)it.next();
                    if (!(child instanceof UIColumn) || !child.isRendered()) continue;
                    Iterator columnChildIter = child.getChildren().iterator();
                    while (columnChildIter.hasNext()) {
                        UIComponent columnChild = (UIComponent)columnChildIter.next();
                        this.process(context, columnChild, processAction);
                    }
                }
            }
            ++rowIndex;
        }
    }

    private void process(FacesContext context, UIComponent component, int processAction) {
        switch (processAction) {
            case 1: {
                component.processDecodes(context);
                break;
            }
            case 2: {
                component.processValidators(context);
                break;
            }
            case 3: {
                component.processUpdates(context);
            }
        }
    }

    private DataModel getDataModel() {
        UIData embeddingUIData = this.getEmbeddingUIData();
        if (embeddingUIData != null) {
            String embeddingClientId;
            DataModel dataModel;
            if (this._dataModelMap == null) {
                this._dataModelMap = new HashMap();
            }
            if ((dataModel = (DataModel)this._dataModelMap.get(embeddingClientId = embeddingUIData.getClientId(FacesContext.getCurrentInstance()))) == null) {
                dataModel = this.createDataModel();
                this._dataModelMap.put(embeddingClientId, dataModel);
            }
            return dataModel;
        }
        if (this._dataModel == null) {
            this._dataModel = this.createDataModel();
        }
        return this._dataModel;
    }

    private DataModel createDataModel() {
        Object value = this.getValue();
        if (value == null) {
            return EMPTY_DATA_MODEL;
        }
        if (value instanceof DataModel) {
            return (DataModel)value;
        }
        if (value instanceof List) {
            return new ListDataModel((List)value);
        }
        if (value instanceof Collection) {
            return new ListDataModel(new ArrayList((Collection)value));
        }
        if (OBJECT_ARRAY_CLASS.isAssignableFrom(value.getClass())) {
            return new ArrayDataModel((Object[])value);
        }
        if (value instanceof ResultSet) {
            return new ResultSetDataModel((ResultSet)value);
        }
        if (value instanceof Result) {
            return new ResultDataModel((Result)value);
        }
        return new ScalarDataModel(value);
    }

    private UIData getEmbeddingUIData() {
        if (this._isEmbeddedUIData == null) {
            UIComponent findParentUIData = this.getParent();
            while (findParentUIData != null && !(findParentUIData instanceof UIData)) {
                findParentUIData = findParentUIData.getParent();
            }
            if (findParentUIData != null) {
                this._embeddingUIData = (UIData)findParentUIData;
                this._isEmbeddedUIData = Boolean.TRUE;
            } else {
                this._isEmbeddedUIData = Boolean.FALSE;
            }
        }
        if (this._isEmbeddedUIData.booleanValue()) {
            return this._embeddingUIData;
        }
        return null;
    }

    public void setValue(Object value) {
        this._value = value;
        this._dataModel = null;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._first, this._rows, this._value, this._var, this._rowState};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._first = (Integer)values[1];
        this._rows = (Integer)values[2];
        this._value = values[3];
        this._var = (String)values[4];
        this._rowState = (UIDataRowState)values[5];
        this._firstTimeRendered = false;
    }

    public UIData() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public String getFamily() {
        return "javax.faces.Data";
    }

    public void setFirst(int first) {
        this._first = new Integer(first);
    }

    public int getFirst() {
        if (this._first != null) {
            return this._first;
        }
        ValueBinding vb = this.getValueBinding("first");
        Integer v = vb != null ? (Integer)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : 0;
    }

    public int getRows() {
        if (this._rows != null) {
            return this._rows;
        }
        ValueBinding vb = this.getValueBinding("rows");
        Integer v = vb != null ? (Integer)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : 0;
    }

    public Object getValue() {
        if (this._value != null) {
            return this._value;
        }
        ValueBinding vb = this.getValueBinding("value");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    private static class EditableValueHolderState
    implements Serializable {
        private Object _localValue;
        private boolean _localValueSet;
        private boolean _valid;
        private Object _submittedValue;

        public EditableValueHolderState(EditableValueHolder vh) {
            this._localValue = vh.getLocalValue();
            this._localValueSet = vh.isLocalValueSet();
            this._valid = vh.isValid();
            this._submittedValue = vh.getSubmittedValue();
        }

        public EditableValueHolderState(EditableValueHolderState state) {
            this._localValue = state._localValue;
            this._localValueSet = state._localValueSet;
            this._valid = state._valid;
            this._submittedValue = state._submittedValue;
        }

        public void restore(EditableValueHolder vh) {
            vh.setValue(this._localValue);
            vh.setLocalValueSet(this._localValueSet);
            vh.setValid(this._valid);
            vh.setSubmittedValue(this._submittedValue);
        }
    }

    private static class UIDataRowState
    implements Cloneable,
    Serializable {
        private HashMap _clientIdsToChildUIDataStates = new HashMap();
        private HashMap _clientIdsToChildEVHStates = new HashMap();

        public UIDataRowState() {
        }

        public UIDataRowState(UIDataRowState initial) {
            Iterator i = initial._clientIdsToChildEVHStates.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                EditableValueHolderState initialState = (EditableValueHolderState)entry.getValue();
                this._clientIdsToChildEVHStates.put(entry.getKey(), new EditableValueHolderState(initialState));
            }
            Iterator i2 = initial._clientIdsToChildUIDataStates.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                UIDataRowState initialState = (UIDataRowState)entry.getValue();
                this._clientIdsToChildEVHStates.put(entry.getKey(), new UIDataRowState(initialState));
            }
        }
    }

    private static class FacesEventWrapper
    extends FacesEvent {
        private FacesEvent _wrappedFacesEvent;
        private int _rowIndex;

        public FacesEventWrapper(FacesEvent facesEvent, int rowIndex, UIData redirectComponent) {
            super(redirectComponent);
            this._wrappedFacesEvent = facesEvent;
            this._rowIndex = rowIndex;
        }

        public PhaseId getPhaseId() {
            return this._wrappedFacesEvent.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this._wrappedFacesEvent.setPhaseId(phaseId);
        }

        public void queue() {
            this._wrappedFacesEvent.queue();
        }

        public String toString() {
            return this._wrappedFacesEvent.toString();
        }

        public boolean isAppropriateListener(FacesListener faceslistener) {
            return this._wrappedFacesEvent.isAppropriateListener(faceslistener);
        }

        public void processListener(FacesListener faceslistener) {
            this._wrappedFacesEvent.processListener(faceslistener);
        }

        public FacesEvent getWrappedFacesEvent() {
            return this._wrappedFacesEvent;
        }

        public int getRowIndex() {
            return this._rowIndex;
        }
    }

    private static class UIDataRowIndexState {
        private UIData _uiData;
        private int _rowIndex;

        public UIDataRowIndexState(UIData uiData) {
            this._uiData = uiData;
            this._rowIndex = this._uiData._rowIndex;
        }

        public void restore() {
            this._uiData._rowIndex = this._rowIndex;
        }
    }
}

