/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.jsf.util.LongValidatorUtil;
import org.seasar.jsf.util.MessageUtil;
import org.seasar.jsf.util.UIComponentUtil;

public class S2LongRangeValidator
implements Validator,
StateHolder {
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MINIMUM";
    private Long minimum = null;
    private Long maximum = null;
    private boolean bTransient = false;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (value == null) {
            return;
        }
        double dvalue = LongValidatorUtil.parseLongValue(context, component, value);
        if (this.minimum != null && this.maximum != null) {
            if (dvalue < (double)this.minimum.longValue() || dvalue > (double)this.maximum.longValue()) {
                Object[] args = new Object[]{this.minimum, this.maximum, UIComponentUtil.getLabel(component)};
                throw new ValidatorException(MessageUtil.getErrorMessage("javax.faces.validator.NOT_IN_RANGE", args));
            }
        } else if (this.minimum != null) {
            if (dvalue < (double)this.minimum.longValue()) {
                Object[] args = new Object[]{this.minimum, UIComponentUtil.getLabel(component)};
                throw new ValidatorException(MessageUtil.getErrorMessage(MINIMUM_MESSAGE_ID, args));
            }
        } else if (this.maximum != null && dvalue > (double)this.maximum.longValue()) {
            Object[] args = new Object[]{this.maximum, UIComponentUtil.getLabel(component)};
            throw new ValidatorException(MessageUtil.getErrorMessage(MAXIMUM_MESSAGE_ID, args));
        }
    }

    public long getMaximum() {
        return this.maximum != null ? this.maximum : Long.MAX_VALUE;
    }

    public void setMaximum(long maximum) {
        this.maximum = new Long(maximum);
    }

    public long getMinimum() {
        return this.minimum != null ? this.minimum : Long.MIN_VALUE;
    }

    public void setMinimum(long minimum) {
        this.minimum = new Long(minimum);
    }

    public boolean isTransient() {
        return this.bTransient;
    }

    public void setTransient(boolean transientValue) {
        this.bTransient = transientValue;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.maximum, this.minimum};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maximum = (Long)values[0];
        this.minimum = (Long)values[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof S2LongRangeValidator)) {
            return false;
        }
        S2LongRangeValidator longRangeValidator = (S2LongRangeValidator)o;
        if (this.maximum != null ? !this.maximum.equals(longRangeValidator.maximum) : longRangeValidator.maximum != null) {
            return false;
        }
        return !(this.minimum != null ? !this.minimum.equals(longRangeValidator.minimum) : longRangeValidator.minimum != null);
    }
}

