/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.autoregister.AbstractAutoRegister;
import org.seasar.framework.container.autoregister.ClassPattern;
import org.seasar.framework.container.factory.AspectDefFactory;

public class AspectAutoRegister
extends AbstractAutoRegister {
    private MethodInterceptor interceptor;
    private String pointcut;

    public void setInterceptor(MethodInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void setPointcut(String pointcut) {
        this.pointcut = pointcut;
    }

    public void registAll() {
        S2Container container = this.getContainer();
        int i = 0;
        while (i < container.getComponentDefSize()) {
            ComponentDef cd = container.getComponentDef(i);
            this.regist(cd);
            ++i;
        }
    }

    protected void regist(ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        if (componentDef.getAspectDefSize() > 0) {
            return;
        }
        String className = componentClass.getName();
        int i = 0;
        while (i < this.getClassPatternSize()) {
            String shortClassName;
            ClassPattern cp = this.getClassPattern(i);
            String packageName = cp.getPackageName();
            if (className.startsWith(packageName) && !this.isIgnore(packageName, shortClassName = className.substring(packageName.length() + 1)) && cp.isAppliedShortClassName(shortClassName)) {
                this.registInterceptor(componentDef);
                return;
            }
            ++i;
        }
    }

    protected void registInterceptor(ComponentDef componentDef) {
        AspectDef aspectDef = AspectDefFactory.createAspectDef(this.interceptor, this.pointcut);
        componentDef.addAspectDef(aspectDef);
    }
}

