/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import java.io.File;
import org.seasar.framework.container.autoregister.AbstractComponentAutoRegister;
import org.seasar.framework.container.autoregister.ClassPattern;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public class FileSystemComponentAutoRegister
extends AbstractComponentAutoRegister {
    private String fileNameOfRoot = "j2ee.dicon";

    public void setFileNameOfRoot(String fileNameOfRoot) {
        this.fileNameOfRoot = fileNameOfRoot;
    }

    public void registAll() {
        int i = 0;
        while (i < this.getClassPatternSize()) {
            ClassPattern cp = this.getClassPattern(i);
            this.regist(cp);
            ++i;
        }
    }

    protected void regist(ClassPattern classPattern) {
        String packageName = classPattern.getPackageName();
        File packageDir = this.getPackageDir(packageName);
        this.regist(classPattern, packageDir, packageName);
    }

    protected void regist(ClassPattern classPattern, File packageDir, String packageName) {
        File[] files = packageDir.listFiles();
        int i = 0;
        while (i < files.length) {
            String shortClassName;
            File file = files[i];
            String fileName = file.getName();
            if (file.isDirectory()) {
                this.regist(classPattern, file, ClassUtil.concatName(packageName, fileName));
            } else if (fileName.endsWith(".class") && !this.isIgnore(packageName, shortClassName = fileName.substring(0, fileName.length() - ".class".length())) && classPattern.isAppliedShortClassName(shortClassName)) {
                this.regist(packageName, shortClassName);
            }
            ++i;
        }
    }

    protected File getPackageDir(String packageName) {
        File packageDir = this.getRootDir();
        if (packageName != null) {
            String[] names = StringUtil.split(packageName, ".");
            int i = 0;
            while (i < names.length) {
                packageDir = new File(packageDir, names[i]);
                ++i;
            }
        }
        return packageDir;
    }

    protected File getRootDir() {
        return ResourceUtil.getResourceAsFile(this.fileNameOfRoot).getParentFile();
    }
}

