package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.Conversion;
import org.seasar.util.SeasarException;

public final class ConcatenateExp implements Expression {

    private final Expression[] _exps;

    public ConcatenateExp(final Expression[] exps) {
    	Assertion.assertNotNull("exps", exps);
    	
        _exps = exps;
    }


    public Object evaluateValue(RuleContext ruleContext) throws SeasarException {
    	StringBuffer buf = new StringBuffer(100);
    	for (int i = 0; i < _exps.length; ++i) {
    		Expression exp = _exps[i];
    		String arg = Conversion.toString(exp.evaluateValue(ruleContext), null);
    		buf.append(arg);
    	}
        return buf.toString();
    }
}
