package org.seasar.nazuna;

import org.seasar.util.SeasarException;

public final class GreaterThanExp extends AbstractCompareExp {

    public GreaterThanExp(Expression arg1Exp, Expression arg2Exp) {
        super(arg1Exp, arg2Exp);
    }


    public boolean evaluate(RuleContext ruleContext) throws SeasarException {
        Comparable arg1 = getArg1(ruleContext);
        Comparable arg2 = getArg2(ruleContext);
        if (arg1 == null || arg2 == null) {
            return false;
        } else {
            return arg1.compareTo(arg2) > 0;
        }
    }
}
