package org.seasar.nazuna;

import java.io.File;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;

import org.seasar.util.Reflector;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;
import org.seasar.util.SeasarRuntimeException;
import org.seasar.util.StringUtil;

public final class NazunaUtil {

	private static Map _targetClasses = new SMap();
	
	static {
		_targetClasses.put(Integer.class, Integer.TYPE);
		_targetClasses.put(Long.class, Long.TYPE);
		_targetClasses.put(Double.class, Double.TYPE);
		_targetClasses.put(Float.class, Float.TYPE);
		_targetClasses.put(Boolean.class, Boolean.TYPE);
	}
	
    private NazunaUtil() {
    }
    
    public static Class getTargetClass(final Class clazz) {
//    	if (clazz == Integer.class) {
//    		return Integer.TYPE;
//    	} else if (clazz == Long.class) {
//    		return Long.TYPE;
//		} else if (clazz == Boolean.class) {
//			return Boolean.TYPE;
//    	} else {
//    		return clazz;
//    	}
        Class ret = (Class) _targetClasses.get(clazz);
        if (ret != null) {
        	return ret;
        } else {
        	return clazz;
        }
    }
    
    public static Object[] getArgs(final Expression[] argExps, final RuleContext ruleContext)
    		throws SeasarException {
    			
    	Object[] args = new Object[argExps.length];
    	for (int i = 0; i < args.length; ++i) {
    		args[i] = argExps[i].evaluateValue(ruleContext);
    	}
    	return args;
    }
    
    public static boolean isConstName(String name) {
    	for (int i = 0; i < name.length(); ++i) {
    		char c = name.charAt(i);
    		if (!isConstNameChar(c)) {
    			return false;
    		}
    	}
    	return true;
    }
    
    public static boolean isConstNameChar(char c) {
    	return 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_';
    }
    
    public static boolean isVarArgStartChar(char c) {
    	return 'a' <= c && c <= 'z';
    }
    
    public static boolean isClassName(String targetName) {
    	int pos = targetName.lastIndexOf('.') + 1;
    	return Character.isUpperCase(targetName.charAt(pos));
    }
    
    public static Expression[] toExpressionArray(List expList) {
    	return (Expression[]) expList.toArray(new Expression[expList.size()]);
    }
    
    public static BooleanExpression[] toBooleanExpressionArray(List boolExpList) {
    	return (BooleanExpression[]) boolExpList.toArray(
    		new BooleanExpression[boolExpList.size()]);
    }

	public static final Object getProperty(final Object target, final String propertyName)
    		throws SeasarException {
    			
    	if (target instanceof Map) {
    		return ((Map) target).get(propertyName);
    	} else if (target.getClass().isArray() && "length".equals(propertyName)) {
    		return new Integer(Array.getLength(target));
    	} else {
        	return Reflector.getProperty(target, propertyName);
    	}
    }

	public static final void setProperty(final Object target, final String propertyName,
    		final Object value) throws SeasarException {
    			
    	if (target instanceof Map) {
    		((Map) target).put(propertyName, value);
    	} else {
        	Reflector.setProperty2(target, propertyName, value);
    	}
    }

    public static List filter(List items, String condition)
			throws SeasarException {
				
		return filter(items, condition, null);
	}
			
	public static List filter(List items, String condition, Map parameters)
			throws SeasarException {
				
		FilterDesc filterDesc = new FilterDesc(condition);
		return filterDesc.filter(items, parameters);
	}
	
	public static Object filterFirst(List items, String condition)
			throws SeasarException {
				
		return filterFirst(items, condition, null);
	}
			
	public static Object filterFirst(List items, String condition, Map parameters)
			throws SeasarException {
				
		FilterDesc filterDesc = new FilterDesc(condition);
		return filterDesc.filterFirst(items, parameters);
	}
	
	public static List sort(List items, String clause)
			throws SeasarException {
				
		SortDesc sortDesc = new SortDesc(clause);
		return sortDesc.sort(items);
	}
	
	public static List group(List items, String clause)
			throws SeasarException {
				
		GroupDesc groupDesc = new GroupDesc(clause);
		return groupDesc.group(items);
	}
	
	public static void appendToolsJarPath(StringBuffer buf) {
		String s = System.getProperty("java.home");
		int pos = s.lastIndexOf(File.separator);
		buf.append(s.substring(0, pos));
    	buf.append(File.separator);
    	buf.append("lib");
    	buf.append(File.separator);
    	buf.append("tools.jar");
	}
	
	public static String getToolsJarPath() {
		StringBuffer buf = new StringBuffer();
		appendToolsJarPath(buf);
		return buf.toString();
	}
	
	public static URL getToolsJarURL() {
		try {
			return new File(getToolsJarPath()).toURL();
		} catch (MalformedURLException ex) {
			throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
		}
	}

	public static Class getClass(String className) {
		if (StringUtil.isEmpty(className)) {
			return Object.class;
		}
		if (className.endsWith("[]")) {
			className = "[L" + className.substring(0, className.length() - 2) + ";";
		}
		return Reflector.getClass(className);
	}
}
