package org.seasar.nazuna;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class ToStringExp implements Expression {

    private final Expression _arg1Exp;
    private final String _pattern;

    public ToStringExp(final Expression arg1Exp, final String pattern) {
    	Assertion.assertNotNull("arg1Exp", arg1Exp);

        _arg1Exp = arg1Exp;
        _pattern = pattern;
    }

    public Object evaluateValue(final RuleContext ruleContext) throws SeasarException {
        Object arg1 = _arg1Exp.evaluateValue(ruleContext);
        if (arg1 == null) {
            return null;
        } else if (_pattern != null && arg1 instanceof Date) {
            return new SimpleDateFormat(_pattern).format(arg1);
        } else if (_pattern != null && arg1 instanceof Number) {
            return new DecimalFormat(_pattern).format(arg1);
        } else {
            return arg1.toString();
        }
    }
}
