package org.seasar.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class Like {

	private static Map _patterns = new HashMap();
		
	private Like() {
	}
	
	public static final boolean match(final String likePattern, final String value) {
		if (StringUtil.isEmpty(likePattern)) {
			return false;
		}
		Pattern pattern = (Pattern) _patterns.get(likePattern);
		if (pattern == null) {
			synchronized (_patterns) {
				pattern = (Pattern) _patterns.get(likePattern);
				if (pattern == null) {
					String regexp = StringUtil.replace(likePattern, "_", ".");
					regexp = StringUtil.replace(regexp, "%", ".*");
					pattern = Pattern.compile(regexp);
					_patterns.put(likePattern, pattern);
				}
			}
		}
		return pattern.matcher(value).matches();
	}
}