package org.seasar.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public final class StringUtil {
	
	private StringUtil() {}
	
	public static final String getLastToken(final String target, final char delim) {
		int pos = target.lastIndexOf(delim);
		if (pos < 0) {
			return target;
		}
		return target.substring(pos + 1);
	}
	
	public static final boolean isEmpty(final String text) {
		return text == null || text.length() == 0 ? true : false;
	}
	
	public static boolean isSpace(char ch) {
        return (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t');
    }
	
	public static String[] split(final String str, final String delim) {
        if (str == null) {
            return ArrayUtil.EMPTY_STRINGS;
        }
        List list = new ArrayList();
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreElements()) {
            list.add(st.nextElement());
        }
        return (String[]) list.toArray(ArrayUtil.EMPTY_STRINGS);
    }

	
	public static final String ltrim(final String text) {
		return ltrim(text, null);
	}
	
	public static final String ltrim(final String text, String trimText) {
		if (text == null) {
			return null;
		}
		if (trimText == null) {
			trimText = " ";
		}
		int pos = 0;
		for ( ; pos < text.length(); pos++) {
			if (trimText.indexOf(text.charAt(pos)) < 0) {
				break;
			}
		}
		return text.substring(pos);
	}
	
	public static final String rcut(final String text, String cutText) {
		if (text == null) {
			return null;
		}
		if (isEmpty(cutText) || !text.endsWith(cutText)) {
			return text;
		}
		return text.substring(0, text.length() - cutText.length());
	}
	
	public static final String rtrim(final String text) {
		return rtrim(text, null);
	}
	
	public static final String rtrim(final String text, String trimText) {
		if (text == null) {
			return null;
		}
		if (trimText == null) {
			trimText = " ";
		}
		int pos = text.length() - 1;
		for ( ; pos >= 0; pos--) {
			if (trimText.indexOf(text.charAt(pos)) < 0) {
				break;
			}
		}
		return text.substring(0, pos + 1);
	}
	
	public static final String btrim(final String text) {
		return btrim(text, " ");
	}
	
	public static final String btrim(final String text, String trimText) {
		if (text == null) {
			return null;
		}
		int pos = 0;
		for ( ; pos < text.length(); pos++) {
			if (trimText.indexOf(text.charAt(pos)) < 0) {
				break;
			}
		}
		int pos2 = text.length() - 1;
		for ( ; pos2 > pos; pos2--) {
			if (trimText.indexOf(text.charAt(pos2)) < 0) {
				break;
			}
		}
		return text.substring(pos, pos2 + 1);
	}
	
	public static final String lpad(final String text, final int length) {
		return lpad(text, length, null);
	}
	
	public static final String lpad(final String text, final int length, String fillText) {
		if (text == null) {
			return null;
		}
		if (fillText == null) {
			fillText = " ";
		}
		if (text.length() >= length) {
			return text.substring(0, length);
		}
		final int num = length - text.length();
		final int div = num / fillText.length();
		final int mod = num % fillText.length();
		StringBuffer buf = new StringBuffer(100);
		for (int i = 0; i < div; i++) {
			buf.append(fillText);
		}
		if (mod > 0) {
			buf.append(fillText.subSequence(0, mod));
		}
		buf.append(text);
		return buf.toString();
	}
	
	public static final String rpad(final String text, final int length) {
		return rpad(text, length, " ");
	}
	
	public static final String rpad(final String text, final int length, String fillText) {
		if (text == null) {
			return null;
		}
		if (text.length() >= length) {
			return text.substring(0, length);
		}
		final int num = length - text.length();
		final int div = num / fillText.length();
		final int mod = num % fillText.length();
		StringBuffer buf = new StringBuffer(100);
		buf.append(text);
		for (int i = 0; i < div; i++) {
			buf.append(fillText);
		}
		if (mod > 0) {
			buf.append(fillText.subSequence(0, mod));
		}
		return buf.toString();
	}
	
	public static final String translate(final String text, final String fromText, final String toText) {
		if (text == null || fromText == null || toText == null) {
			return null;
		}
		StringBuffer buf = new StringBuffer(100);
		for (int i = 0; i < text.length(); i++) {
			char c = text.charAt(i);
			int pos = fromText.indexOf(c);
			if (pos < 0) {
				buf.append(c);
			} else if (pos < toText.length()) {
				buf.append(toText.charAt(pos));
			}
		}
		return buf.toString();
	}
	
	public static final String replace(final String text, final String fromText, final String toText) {
		if (text == null || fromText == null || toText == null) {
			return null;
		}
		StringBuffer buf = new StringBuffer(100);
		int pos = 0;
		int pos2 = 0;
		while (true) {
			pos = text.indexOf(fromText, pos2);
			if (pos == 0) {
				buf.append(toText);
				pos2 = fromText.length();
			} else if (pos > 0) {
				buf.append(text.substring(pos2, pos));
				buf.append(toText);
				pos2 = pos + fromText.length();
			} else {
				buf.append(text.substring(pos2));
				break;
			}
		}
		return buf.toString();
	}
	
	public static final String repeat(final String text, final int count) {
		if (text == null || count < 0) {
			return null;
		}
		StringBuffer buf = new StringBuffer(100);
		for (int i = 0; i < count; i++) {
			buf.append(text);
		}
		return buf.toString();
	}
	
	public static int ascii(final String str) {
        return (int) str.charAt(0);
    }
    
    public static String chr(final int arg) {
        return String.valueOf((char) arg);
    }
    
    public static int length(final String arg) {
        return arg.length();
    }
    
    public static String lower(final String arg) {
        return arg.toLowerCase();
    }
    
    public static String upper(final String arg) {
        return arg.toUpperCase();
    }
    
    public static int strpos(final String str, final String arg) {
        return str.indexOf(arg) + 1;
    }
    
    public static String substr(final String str, final int from) {
        if (str == null) {
        	return null;
        }
        return substr(str, from, str.length());
    }
    
    public static String substr(final String str, final int from, final int count) {
        if (str == null) {
        	return null;
        }
        int f = from - 1;
        if (f < 0) {
        	f = 0;
        } else if (f >= str.length()) {
        	return null;
        }
        if (count <= 0) {
        	return null;
        }
        int t = str.length();
        if (f + count < t) {
        	t = f + count;
        }
        return str.substring(f, t);
    }
    
    public static String substrb(final String str, final int byteLength) {
        if (str == null) {
        	return null;
        }
	    byte[] bytesval = str.getBytes();
	    int len = bytesval.length;
	    String s = str;
	    if (len > byteLength) {
	    	for (int i = byteLength; i >= 0; i--) {
	    		s = new String(bytesval, 0, i);
	    		if (!s.equals("") && ((int)s.charAt(s.length() - 1)) != 65533) {
	    			return s;
	    		}
	    	}
	    }
	    return s;
    }
    
    public static int indexOf(char[] source, char[] target) {
    	return indexOf(source, target, 0);
    }
    
    public static int indexOf(char[] source, char[] target, int fromIndex) {
    	
    	return indexOf(source, 0, source.length, target, 0, target.length, fromIndex);
    }
    
    public static int indexOf(char[] source, int sourceOffset, int sourceCount,
    		char[] target, int targetOffset, int targetCount, int fromIndex) {
    			
		if (fromIndex >= sourceCount) {
	            return (targetCount == 0 ? sourceCount : -1);
		}
    	if (fromIndex < 0) {
    	    fromIndex = 0;
    	}
		if (targetCount == 0) {
		    return fromIndex;
		}
        char targetFirst  = target[targetOffset];
        int sourceFirstPos = sourceOffset + fromIndex;
        int sourceFirstMax = sourceOffset + (sourceCount - targetCount);

    	mainLoop:
        while (true) {
		    while (sourceFirstPos <= sourceFirstMax && source[sourceFirstPos] != targetFirst) {
				++sourceFirstPos;
		    }
		    if (sourceFirstPos > sourceFirstMax) {
				return -1;
		    }
	    	int sourcePos = sourceFirstPos + 1;
	    	int sourcePosMax = sourceFirstPos + targetCount;
	    	int targetPos = targetOffset + 1;
	    	while (sourcePos < sourcePosMax) {
				if (source[sourcePos++] != target[targetPos++]) {
		    		++sourceFirstPos;
		    		continue mainLoop;
				}
	    	}
	    	return sourceFirstPos - sourceOffset;
        }
    }
    
    public static String newString(char[] buf, int off, int len) {
        return new String(buf, off, len).intern();
    }
}
