package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.AddSubExp;
import org.seasar.nazuna.DoubleExp;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.NullExp;
import org.seasar.nazuna.RuleTokenizer;
import org.seasar.nazuna.StringExp;
import org.seasar.nazuna.ToLongExp;

public class AddSubExpTest extends TestCase {

    public AddSubExpTest(String name) {
        super(name);
    }

    public void testAdd() throws Exception {
    	IntegerExp i1Con = new IntegerExp(new Integer(1));
    	IntegerExp i2Con = new IntegerExp(new Integer(2));
    	AddSubExp addSubExp = new AddSubExp(i1Con, i2Con, RuleTokenizer.ADD);
        assertEquals("1", new Integer(3), addSubExp.evaluateValue(null));
    }
    
    public void testAdd2() throws Exception {
    	ToLongExp toLong1Exp = new ToLongExp(new StringExp("1"), null);
    	ToLongExp toLong2Exp = new ToLongExp(new StringExp("2"), null);
    	AddSubExp addSubExp = new AddSubExp(toLong1Exp, toLong2Exp, RuleTokenizer.ADD);
        assertEquals("1", new Long(3), addSubExp.evaluateValue(null));
    }
    
    public void testAdd3() throws Exception {
    	DoubleExp double1Exp = new DoubleExp(new Double(1));
    	DoubleExp double2Exp = new DoubleExp(new Double(2));
    	AddSubExp addSubExp = new AddSubExp(double1Exp, double2Exp, RuleTokenizer.ADD);
        assertEquals("1", new Double(3), addSubExp.evaluateValue(null));
    }
    
    public void testAdd4() throws Exception {
    	IntegerExp i1Con = new IntegerExp(new Integer(1));
    	AddSubExp addSubExp = new AddSubExp(i1Con, new NullExp(), RuleTokenizer.ADD);
        assertEquals("1", null, addSubExp.evaluateValue(null));
    }
    
    public void testSubtract() throws Exception {
    	IntegerExp i1Con = new IntegerExp(new Integer(1));
    	IntegerExp i2Con = new IntegerExp(new Integer(2));
    	AddSubExp addSubExp = new AddSubExp(i1Con, i2Con, RuleTokenizer.SUBTRACT);
        assertEquals("1", new Integer(-1), addSubExp.evaluateValue(null));
    }
    
    public void testSubtract2() throws Exception {
    	ToLongExp toLong1Exp = new ToLongExp(new StringExp("1"), null);
    	ToLongExp toLong2Exp = new ToLongExp(new StringExp("2"), null);
    	AddSubExp addSubExp = new AddSubExp(toLong1Exp, toLong2Exp, RuleTokenizer.SUBTRACT);
        assertEquals("1", new Long(-1), addSubExp.evaluateValue(null));
    }
    
    public void testSubtract3() throws Exception {
    	DoubleExp double1Exp = new DoubleExp(new Double(1));
    	DoubleExp double2Exp = new DoubleExp(new Double(2));
    	AddSubExp addSubExp = new AddSubExp(double1Exp, double2Exp, RuleTokenizer.SUBTRACT);
        assertEquals("1", new Double(-1), addSubExp.evaluateValue(null));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(AddSubExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{AddSubExpTest.class.getName()});
    }
}