package test.org.seasar.nazuna;

import java.io.File;
import java.util.Date;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.Flowlet;
import org.seasar.nazuna.FlowletDeployer;
import org.seasar.util.ResourceUtil;

public class FlowletDeployerTest extends TestCase {
		
    public FlowletDeployerTest(String name) {
        super(name);
    }
    
    public void testDeploy() throws Exception {
    	String name = "test.org.seasar.nazuna.Hello";
    	FlowletDeployer deployer = new FlowletDeployer(name);
    	File file = ResourceUtil.getFile(name, "xml");
    	deployer.deploy();
    	Flowlet flowlet = deployer.getFlowlet();
    	assertNotNull("1", flowlet);
    	assertEquals("2", file.lastModified(),
    		deployer.getLastModified());
        Thread.sleep(1000);
        long now = new Date().getTime();
        file.setLastModified(now);
        deployer.deploy();
    	assertEquals("3", now, deployer.getLastModified());
        assertTrue("4", flowlet != deployer.getFlowlet());
    }
        
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(FlowletDeployerTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{FlowletDeployerTest.class.getName()});
    }
}