package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.BooleanExpression;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.IsNullExp;
import org.seasar.nazuna.NullExp;

public class IsNullExpTest extends TestCase {

    public IsNullExpTest(String name) {
        super(name);
    }

	public void testEvaluate() throws Exception {
        BooleanExpression exp = new IsNullExp(new NullExp());
        assertEquals("1", true, exp.evaluate(null));
    }
    
    public void testEvaluate2() throws Exception {
        IntegerExp arg1Exp = new IntegerExp(new Integer(2));
        BooleanExpression exp = new IsNullExp(arg1Exp);
        assertEquals("1", false, exp.evaluate(null));
    }
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(IsNullExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{IsNullExpTest.class.getName()});
    }
}