package test.org.seasar.util;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.util.ElementHandler;
import org.seasar.util.SeasarRuntimeException;
import org.seasar.util.XMLHandler;
import org.seasar.util.XMLHandlerParser;
import org.seasar.util.XMLHandlerRule;
import org.xml.sax.Attributes;

public class XMLHandlerTest extends TestCase {

	  private static final String XML_FILE_NAME = "test.org.seasar.util.test1";
    private XMLHandlerRule _rule;

    public XMLHandlerTest(String name) {
        super(name);
    }

    public void testStart() throws Exception {
        _rule.addElementHandler("/tag1",
            new ElementHandler() {
                public void start(XMLHandler xmlHandler, Attributes attributes) {
                    xmlHandler.push(attributes.getValue("attr1"));
                }
            });
        assertEquals("1", "aaa", XMLHandlerParser.parse(XML_FILE_NAME, _rule));
    }
    
    public void testAppendBody() throws Exception {
    	final StringBuffer buf = new StringBuffer();
        _rule.addElementHandler("/tag1",
            new ElementHandler() {
                public void appendBody(XMLHandler xmlHandler, String body) {
                    buf.append("[" + body + "]");
                }
            });
        XMLHandlerParser.parse(XML_FILE_NAME, _rule);
        System.out.println(buf);
        assertEquals("1", "[111][222][333]", buf.toString());
    }
    
    public void testAppendBody2() throws Exception {
    	final StringBuffer buf = new StringBuffer();
        _rule.addElementHandler("tag1",
            new ElementHandler() {
                public void appendBody(XMLHandler xmlHandler, String body) {
                    buf.append("[" + body + "]");
                }
            });
        XMLHandlerParser.parse(XML_FILE_NAME, _rule, false);
        System.out.println(buf);
        assertEquals("1", "[111][222][333]", buf.toString());
    }

    public void testEnd() throws Exception {
        _rule.addElementHandler("/tag1/tag2",
            new ElementHandler() {
                public void end(XMLHandler xmlHandler, String body) {
                    xmlHandler.push(body);
                }
            });
        assertEquals("1", "c c", XMLHandlerParser.parse(XML_FILE_NAME, _rule));
    }
    
    public void testException() throws Exception {
        _rule.addElementHandler("/tag1/tag3",
            new ElementHandler() {
                public void start(XMLHandler xmlHandler, Attributes attributes) {
                    throw new RuntimeException("testException");
                }
            });
        try {
        	XMLHandlerParser.parse(XML_FILE_NAME, _rule);
        } catch (SeasarRuntimeException ex) {
        	System.out.println(ex);
        }
    }
    
    public void testTagMatching() throws Exception {
    	ElementHandler eh = new ElementHandler() {
                public void start(XMLHandler xmlHandler, Attributes attributes) {
                    System.out.println(xmlHandler.getLocationDetailPath());
                }
            };
        _rule.addElementHandler("tag1", eh);
        _rule.addElementHandler("tag2", eh);
        _rule.addElementHandler("tag3", eh);
        _rule.addElementHandler("tag4", eh);
        _rule.addElementHandler("tag5", eh);
        System.out.println("tagMatching");
        XMLHandlerParser.parse(XML_FILE_NAME, _rule, null, false);
    }
    
    public void testPeek() throws Exception {
    	XMLHandler xmlHandler = new XMLHandler(_rule);
    	xmlHandler.push("aaa");
    	xmlHandler.push(new ArrayList());
    	xmlHandler.push("bbb");
    	assertNotNull("1", xmlHandler.peek(List.class));
    	assertNull("2", xmlHandler.peek(Integer.class));
    	assertEquals("3", "bbb", xmlHandler.peek(String.class));
    }

    protected void setUp() throws Exception {
        _rule = new XMLHandlerRule();
    }

    protected void tearDown() throws Exception {
        _rule = null;
    }

    public static Test suite() {
        return new TestSuite(XMLHandlerTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{XMLHandlerTest.class.getName()});
    }
}
