package test.org.seasar.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.util.XMLUtil;
import org.w3c.dom.Element;

public class XMLUtilTest extends TestCase {

    private Element _root;

    public XMLUtilTest(String name) {
        super(name);
    }

    public void testGetRoot() throws Exception {
        assertNotNull(_root);
    }

    public void testGetAttribute() throws Exception {
        assertNotNull("1", XMLUtil.getAttribute(_root, "attr1"));
        assertNull("2", XMLUtil.getAttribute(_root, "dummy"));
    }

    public void testGetAttributeValue() throws Exception {
        assertEquals("1", "aaa", XMLUtil.getAttributeValue(_root, "attr1"));
        assertNull("2", XMLUtil.getAttributeValue(_root, "dummy"));
    }

    public void testGetNodeValue() throws Exception {
        assertEquals("1", "c c", XMLUtil.getNodeValue(
                _root.getElementsByTagName("tag2").item(0)));
        assertNull("2", XMLUtil.getNodeValue(
                _root.getElementsByTagName("tag3").item(0)));
    }

    public void testGetDocument() throws Exception {
        assertNotNull("1", XMLUtil.getDocument("test.org.seasar.util.test1"));
    }

    public void testGetSAXParser() throws Exception {
        assertNotNull("1", XMLUtil.getSAXParser());
    }

    public void testGetPackedString() throws Exception {
        String s = "a\n \tb     c";
        assertEquals("1", "a b c", XMLUtil.getPackedString(s));
    }
    
    public void testGetContentsAsStream() throws Exception {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo/>";
        assertNotNull("1", XMLUtil.getContentsAsStream(contents, "UTF-8"));
    }
    
    public void testToString() throws Exception {
        String contents = XMLUtil.toString(_root);
        System.out.println(contents);
    }

    protected void setUp() throws Exception {
        _root = XMLUtil.getRoot("test.org.seasar.util.test1");
    }

    protected void tearDown() throws Exception { }

    public static Test suite() {
        return new TestSuite(XMLUtilTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{XMLUtilTest.class.getName()});
    }
}
