/*
class seasar.unit.TestSuite extends seasar.unit.TestCase

public:
void addTest(seasar.unit.TestCase test)

protected:
void runTest(seasar.unit.TestResult testResult)

private:
Array tests
*/
if (seasar.unit.TestSuite === undefined) {
	#include "seasar/lang/SObject.as"
	#include "seasar/unit/TestCase.as"
	
	seasar.lang.SObject.defineClass("seasar.unit.TestSuite", seasar.unit.TestCase, ["tests"],
		function() {
			super();
			this.tests = new Array();
		});
		
	var proto = seasar.unit.TestSuite.prototype;
	
	proto.addTest = function(test) {
		this.tests.push(test);
	}
	
	proto.runTest = function(testResult) {
		var n = this.tests.length;
		for (var i = 0; i < n; ++i) {
			var test = this.tests[i];
			test.runTest(testResult);
		}
	}
	
	ASSetPropFlags(proto, "tests,addTest,runTest",1);
	
	delete proto;
}