package org.seasar.nazuna;

import java.sql.ResultSet;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public abstract class PropertyType {

	protected String _name;
	protected String _columnName;
	protected ValueType _valueType;

	public PropertyType(String name, String columnName, ValueType valueType) {
		Assertion.assertNotNull("name", name);
		Assertion.assertNotNull("columnName", columnName);
		Assertion.assertNotNull("valueType", valueType);

		_name = name;
		_columnName = columnName;
		_valueType = valueType;
	}

	public String getName() {
		return _name;
	}

	public String getColumnName() {
		return _columnName;
	}

	public ValueType getValueType() {
		return _valueType;
	}

	public abstract void fetch(ResultSet rs, Object target)
		throws SeasarException;
}
